/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.mail;

import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.mail.FreemarkerSupport;
import de.riwagis.util.mail.IcsDefinition;
import de.riwagis.util.mail.MailConfig;
import de.riwagis.util.mail.MailType;
import de.riwagis.util.mail.SMTPConfig;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class MailSupport {
    private static final String MDC_SMTP_LOGIN = "smtp_login";
    private static final String MDC_SMTP_CONNECTION = "smtp_connection";
    private static final Logger LOG = LoggerFactory.getLogger(MailSupport.class);
    public static final Charset MAIL_CHARSET = StandardCharsets.UTF_8;
    public static final int MAXLENGTH_SUBJECT = 75;

    public static void fillSMTPConfig(Email mail, SMTPConfig smtpConfig) throws EmailException {
        smtpConfig.fillMail(mail);
    }

    public static final MultiPartEmail createMultipartMail() {
        return MailSupport.createMultipartMail(MAIL_CHARSET);
    }

    public static final MultiPartEmail createMultipartMail(Charset charset) {
        MultiPartEmail email = new MultiPartEmail();
        email.setCharset(charset == null ? MAIL_CHARSET.name() : charset.name());
        return email;
    }

    public static String cleanupSubject(String subjectText) throws EmailException {
        String abbreviatedSubject = MailSupport.abbreviateSubject(subjectText);
        return MailSupport.encodeSubject(abbreviatedSubject);
    }

    public static String abbreviateSubject(String subjectText) {
        return MailSupport.abbreviateSubject(subjectText, 75);
    }

    public static String abbreviateSubject(String subjectText, int maxLength) {
        String cleanSubjectText = StringUtils.defaultString((String)subjectText).replaceAll("(\\r|\\r\\n|\\n|\\n\\r)", " ").replaceAll("\\s+", " ").trim();
        return StringUtils.abbreviate((String)cleanSubjectText, (String)"...", (int)maxLength);
    }

    public static String encodeSubject(String subject) throws EmailException {
        return MailSupport.encodeSubject(subject, MAIL_CHARSET);
    }

    public static String encodeSubject(String subject, Charset charset) throws EmailException {
        try {
            return MimeUtility.encodeText((String)subject, (String)charset.name(), null);
        }
        catch (UnsupportedEncodingException encEx) {
            throw new EmailException(String.format("unable to encode subject '%s' to charset '%s': %s", subject, charset.name(), encEx.getMessage()), (Throwable)encEx);
        }
    }

    private MailSupport() {
    }

    public static final void addBcc(String[] addresses, Email email) throws EmailException {
        for (String currAddress : MailSupport.sanitizeAddresses(addresses)) {
            email.addBcc(currAddress);
        }
    }

    public static final void addBcc(String address, Email email) throws EmailException {
        MailSupport.addBcc(new String[]{address}, email);
    }

    public static final void addCc(String[] addresses, Email email) throws EmailException {
        for (String currAddress : MailSupport.sanitizeAddresses(addresses)) {
            email.addCc(currAddress);
        }
    }

    public static final void addCc(String address, Email email) throws EmailException {
        MailSupport.addCc(new String[]{address}, email);
    }

    public static final void addTo(String[] addresses, Email email) throws EmailException {
        for (String currAddress : MailSupport.sanitizeAddresses(addresses)) {
            email.addTo(currAddress);
        }
    }

    public static final void addTo(String address, Email email) throws EmailException {
        MailSupport.addTo(new String[]{address}, email);
    }

    public static final void addAttachment(MultiPartEmail mail, File file) throws EmailException {
        if (!file.exists() || file.isDirectory()) {
            throw new EmailException("Attachment file not found.");
        }
        EmailAttachment attachment = new EmailAttachment();
        String strPath = file.toString();
        attachment.setPath(strPath);
        attachment.setDisposition("attachment");
        attachment.setName(FilenameUtils.getName((String)strPath));
        mail.attach(attachment);
    }

    public static final void fillMail(Email mail, SMTPConfig smtpConfig, String strSubject) throws EmailException {
        MailSupport.fillSMTPConfig(mail, smtpConfig);
        try {
            mail.setSubject(MimeUtility.encodeText((String)strSubject, (String)MAIL_CHARSET.name(), (String)"Q"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new EmailException("Unsupported encoding encountered", (Throwable)ex);
        }
    }

    public static final void fillMail(Email mail, SMTPConfig smtpConfig, String strTo, String strSubject) throws EmailException {
        MailSupport.fillMail(mail, smtpConfig, strSubject);
        MailSupport.addTo(strTo, mail);
    }

    public static final void fillMail(Email mail, SMTPConfig smtpConfig, String strTo, String strCc, String strBcc, String strSubject) throws EmailException {
        MailSupport.fillMail(mail, smtpConfig, strSubject);
        MailSupport.addTo(strTo, mail);
        MailSupport.addCc(strCc, mail);
        MailSupport.addBcc(strBcc, mail);
    }

    @Deprecated
    public static void sendSimpleMail(SMTPConfig smtpConfig, String strTo, String mailSubject, String mailMessage) throws EmailException {
        MailSupport.sendSimpleMail(smtpConfig, strTo, "", "", mailSubject, mailMessage);
    }

    @Deprecated
    public static void sendSimpleMail(SMTPConfig smtpConfig, String strTo, String strCc, String strBcc, String mailSubject, String mailMessage) throws EmailException {
        try (MDC.MDCCloseable smtp_connection = MDC.putCloseable((String)MDC_SMTP_CONNECTION, (String)String.format("%s:%d", smtpConfig.getSmtpHost(), smtpConfig.getSmtpPort()));
             MDC.MDCCloseable smtp_login = MDC.putCloseable((String)MDC_SMTP_LOGIN, (String)smtpConfig.getSmtpLogin());){
            SimpleEmail mail = new SimpleEmail();
            mail.setCharset(MAIL_CHARSET.name());
            MailSupport.fillMail((Email)mail, smtpConfig, strTo, strCc, strBcc, mailSubject);
            mail.addHeader("charset", MAIL_CHARSET.name());
            mail.setMsg(mailMessage);
            LOG.info(String.format("Sending text mail to '%s'%s%s: '%s'", strTo, StringUtils.isNotBlank((CharSequence)strCc) ? String.format(", cc: '%s'", strCc) : "", StringUtils.isNotBlank((CharSequence)strBcc) ? String.format(", bcc: '%s'", strBcc) : "", mailSubject));
            mail.send();
        }
    }

    @Deprecated
    public static void sendSimpleMail(String strMailHost, String strTo, String strFrom, String strSubject, String strTextMsg) throws SystemException {
        try {
            MailSupport.sendSimpleMail(new SMTPConfig(strMailHost, strFrom), strTo, strSubject, strTextMsg);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendSimpleMail(String strMailHost, String strTo, String strCc, String strBcc, String strFrom, String strSubject, String strTextMsg) throws SystemException {
        try {
            MailSupport.sendSimpleMail(new SMTPConfig(strMailHost, strFrom), strTo, strCc, strBcc, strSubject, strTextMsg);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendHtmlMail(SMTPConfig smtpConfig, String strTo, String strSubject, String strHtmlMsg, String strTextMsg) throws EmailException {
        MailSupport.sendHtmlMail(smtpConfig, strTo, "", "", strSubject, strHtmlMsg, strTextMsg);
    }

    @Deprecated
    public static void sendHtmlMail(SMTPConfig smtpConfig, String strTo, String strCc, String strBcc, String strSubject, String strHtmlMsg, String strTextMsg) throws EmailException {
        try (MDC.MDCCloseable smtp_connection = MDC.putCloseable((String)MDC_SMTP_CONNECTION, (String)String.format("%s:%d", smtpConfig.getSmtpHost(), smtpConfig.getSmtpPort()));
             MDC.MDCCloseable smtp_login = MDC.putCloseable((String)MDC_SMTP_LOGIN, (String)smtpConfig.getSmtpLogin());){
            HtmlEmail mail = new HtmlEmail();
            MailSupport.fillMail((Email)mail, smtpConfig, strTo, strCc, strBcc, strSubject);
            mail.setHtmlMsg(strHtmlMsg);
            mail.setTextMsg((String)StringUtils.defaultIfEmpty((CharSequence)strTextMsg, (CharSequence)"This mail is an HTML message. Please switch to HTML view."));
            LOG.info(String.format("Sending HTML mail to '%s'%s%s: '%s'", strTo, StringUtils.isNotBlank((CharSequence)strCc) ? String.format(", cc: '%s'", strCc) : "", StringUtils.isNotBlank((CharSequence)strBcc) ? String.format(", bcc: '%s'", strBcc) : "", strSubject));
            mail.send();
        }
    }

    @Deprecated
    public static void sendHtmlMail(String strMailHost, String strTo, String strFrom, String strSubject, String strHtmlMsg, String strTextMsg) throws SystemException {
        try {
            MailSupport.sendHtmlMail(new SMTPConfig(strMailHost, strFrom), strTo, strSubject, strHtmlMsg, strTextMsg);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendHtmlMail(String strMailHost, String strTo, String strCc, String strBcc, String strFrom, String strSubject, String strHtmlMsg, String strTextMsg) throws SystemException {
        try {
            MailSupport.sendHtmlMail(new SMTPConfig(strMailHost, strFrom), strTo, strCc, strBcc, strSubject, strHtmlMsg, strTextMsg);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendMultiPartMail(SMTPConfig smtpConfig, String strTo, String strSubject, String strTextMsg, File[] arrFiles, IcsDefinition icsDef) throws EmailException {
        MailSupport.sendMultiPartMail(smtpConfig, strTo, "", "", strSubject, strTextMsg, arrFiles, icsDef);
    }

    @Deprecated
    public static void sendMultiPartMail(SMTPConfig smtpConfig, String strTo, String strSubject, String strTextMsg, File[] arrFiles) throws EmailException {
        MailSupport.sendMultiPartMail(smtpConfig, strTo, "", "", strSubject, strTextMsg, arrFiles);
    }

    @Deprecated
    public static void sendMultiPartMail(SMTPConfig smtpConfig, String strTo, String strCc, String strBcc, String strSubject, String strTextMsg, File[] arrFiles) throws EmailException {
        MailSupport.sendMultiPartMail(smtpConfig, strTo, strCc, strBcc, strSubject, strTextMsg, arrFiles, null);
    }

    @Deprecated
    public static void sendMultiPartMail(SMTPConfig smtpConfig, String strTo, String strCc, String strBcc, String strSubject, String strTextMsg, File[] arrFiles, IcsDefinition icsDef) throws EmailException {
        try (MDC.MDCCloseable smtp_connection = MDC.putCloseable((String)MDC_SMTP_CONNECTION, (String)String.format("%s:%d", smtpConfig.getSmtpHost(), smtpConfig.getSmtpPort()));
             MDC.MDCCloseable smtp_login = MDC.putCloseable((String)MDC_SMTP_LOGIN, (String)smtpConfig.getSmtpLogin());){
            MultiPartEmail mail = MailSupport.createMultipartMail();
            MailSupport.fillMail((Email)mail, smtpConfig, strTo, strCc, strBcc, strSubject);
            mail.setMsg(strTextMsg);
            for (File arrFile : arrFiles) {
                MailSupport.addAttachment(mail, arrFile);
            }
            File icsFile = null;
            if (icsDef != null) {
                try {
                    icsFile = icsDef.createEventFile();
                    if (icsFile != null) {
                        MailSupport.addAttachment(mail, icsFile);
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Error generating ICS File occured", (Throwable)ex);
                    FileUtils.deleteQuietly((File)icsFile);
                }
            }
            LOG.info(String.format("Sending multipart mail to '%s'%s%s: '%s'", strTo, StringUtils.isNotBlank((CharSequence)strCc) ? String.format(", cc: '%s'", strCc) : "", StringUtils.isNotBlank((CharSequence)strBcc) ? String.format(", bcc: '%s'", strBcc) : "", strSubject));
            mail.send();
            FileUtils.deleteQuietly((File)icsFile);
        }
    }

    @Deprecated
    public static void sendMultiPartMail(String strMailHost, String strTo, String strFrom, String strSubject, String strTextMsg, File[] arrFiles) throws SystemException {
        try {
            MailSupport.sendMultiPartMail(new SMTPConfig(strMailHost, strFrom), strTo, strSubject, strTextMsg, arrFiles);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendMultiPartMail(String strMailHost, String strTo, String strFrom, String strSubject, String strTextMsg, File[] arrFiles, IcsDefinition icsDef) throws SystemException {
        try {
            MailSupport.sendMultiPartMail(new SMTPConfig(strMailHost, strFrom), strTo, strSubject, strTextMsg, arrFiles, icsDef);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendMultiPartMail(String strMailHost, String strTo, String strCc, String strBcc, String strFrom, String strSubject, String strTextMsg, File[] arrFiles) throws SystemException {
        try {
            MailSupport.sendMultiPartMail(new SMTPConfig(strMailHost, strFrom), strTo, strCc, strBcc, strSubject, strTextMsg, arrFiles);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    @Deprecated
    public static void sendMultiPartMail(String strMailHost, String strTo, String strCc, String strBcc, String strFrom, String strSubject, String strTextMsg, File[] arrFiles, IcsDefinition icsDef) throws SystemException {
        try {
            MailSupport.sendMultiPartMail(new SMTPConfig(strMailHost, strFrom), strTo, strCc, strBcc, strSubject, strTextMsg, arrFiles, icsDef);
        }
        catch (EmailException e) {
            throw new SystemException(MailSupport.class, (Throwable)e);
        }
    }

    public static final void fillMail(Email mail, SMTPConfig smtpConfig, MailConfig mailConfig) throws EmailException {
        String subject = StringUtils.isNotBlank((CharSequence)mailConfig.getApplicationName()) ? String.format("%s: %s", mailConfig.getApplicationName(), mailConfig.getMailSubject()) : mailConfig.getMailSubject();
        MailSupport.fillMail(mail, smtpConfig, subject);
        MailSupport.addTo(mailConfig.getMailTo(), mail);
        if (StringUtils.isNotEmpty((CharSequence)mailConfig.getMailCc())) {
            MailSupport.addCc(mailConfig.getMailCc(), mail);
        }
        if (StringUtils.isNotEmpty((CharSequence)mailConfig.getMailBcc())) {
            MailSupport.addBcc(mailConfig.getMailBcc(), mail);
        }
    }

    public static SimpleEmail createSimpleMail(SMTPConfig smtpConfig, MailConfig mailConfig) throws EmailException {
        SimpleEmail mail = new SimpleEmail();
        mail.setCharset(MAIL_CHARSET.name());
        MailSupport.fillMail((Email)mail, smtpConfig, mailConfig);
        mail.addHeader("charset", MAIL_CHARSET.name());
        if (mailConfig.getMailTemplatePath() != null) {
            Map<String, Object> paramsPlain = mailConfig.getTemplateParamCopy();
            paramsPlain.put("locale", Config.LOCALE);
            paramsPlain.put("isPlainText", true);
            paramsPlain.put("applicationname", mailConfig.getApplicationName());
            mail.setMsg(FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), paramsPlain));
            Map<String, Object> paramsSubject = mailConfig.getTemplateParamCopy();
            paramsSubject.put("locale", Config.LOCALE);
            paramsSubject.put("isSubject", true);
            paramsSubject.put("applicationname", mailConfig.getApplicationName());
            String subjectText = FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), paramsSubject);
            if (StringUtils.isNotBlank((CharSequence)subjectText)) {
                mail.setSubject(MailSupport.cleanupSubject(subjectText));
            }
        } else {
            mail.setMsg(mailConfig.getPlainTextMessage());
        }
        return mail;
    }

    public static HtmlEmail createHtmlEmail(SMTPConfig smtpConfig, MailConfig mailConfig) throws EmailException {
        HtmlEmail mail = new HtmlEmail();
        mail.setCharset(MAIL_CHARSET.name());
        MailSupport.fillMail((Email)mail, smtpConfig, mailConfig);
        if (mailConfig.getMailTemplatePath() != null) {
            Map<String, Object> paramsHTML = mailConfig.getTemplateParamCopy();
            paramsHTML.put("locale", Config.LOCALE);
            paramsHTML.put("isHtml", true);
            paramsHTML.put("applicationname", mailConfig.getApplicationName());
            mail.setHtmlMsg(FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), paramsHTML));
            Map<String, Object> paramsPlain = mailConfig.getTemplateParamCopy();
            paramsPlain.put("locale", Config.LOCALE);
            paramsPlain.put("isPlainText", true);
            paramsPlain.put("applicationname", mailConfig.getApplicationName());
            mail.setTextMsg(FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), paramsPlain));
            Map<String, Object> paramsSubject = mailConfig.getTemplateParamCopy();
            paramsSubject.put("locale", Config.LOCALE);
            paramsSubject.put("isSubject", true);
            paramsSubject.put("applicationname", mailConfig.getApplicationName());
            String subjectText = FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), paramsSubject);
            if (StringUtils.isNotBlank((CharSequence)subjectText)) {
                mail.setSubject(MailSupport.cleanupSubject(subjectText));
            }
        } else {
            mail.setHtmlMsg(mailConfig.getHtmlMessage());
            mail.setTextMsg((String)StringUtils.defaultIfEmpty((CharSequence)mailConfig.getPlainTextMessage(), (CharSequence)"This mail is an HTML message. Please switch to HTML view."));
        }
        return mail;
    }

    public static MultiPartEmail createMultipartEmail(SMTPConfig smtpConfig, MailConfig mailConfig) throws EmailException {
        MultiPartEmail mail = MailSupport.createMultipartMail();
        MailSupport.fillMail((Email)mail, smtpConfig, mailConfig);
        if (mailConfig.getMailTemplatePath() != null) {
            File[] paramsPlain = mailConfig.getTemplateParamCopy();
            paramsPlain.put((String)"locale", (Object)Config.LOCALE);
            paramsPlain.put("isPlainText", true);
            paramsPlain.put("applicationname", mailConfig.getApplicationName());
            mail.setMsg(FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), (Map<String, Object>)paramsPlain));
            Map<String, Object> paramsSubject = mailConfig.getTemplateParamCopy();
            paramsSubject.put("locale", Config.LOCALE);
            paramsSubject.put("isSubject", true);
            paramsSubject.put("applicationname", mailConfig.getApplicationName());
            String subjectText = FreemarkerSupport.processTemplate(mailConfig.getMailTemplatePath(), paramsSubject);
            if (StringUtils.isNotBlank((CharSequence)subjectText)) {
                mail.setSubject(MailSupport.cleanupSubject(subjectText));
            }
        } else {
            mail.setMsg(mailConfig.getPlainTextMessage());
        }
        if (mailConfig.getFileAttachments() != null) {
            for (File arrFile : mailConfig.getFileAttachments()) {
                MailSupport.addAttachment(mail, arrFile);
            }
        }
        if (mailConfig.getIcsDefinition() != null) {
            try {
                File icsFile = mailConfig.getIcsDefinition().createEventFile();
                if (icsFile != null) {
                    MailSupport.addAttachment(mail, icsFile);
                }
            }
            catch (Exception ex) {
                LOG.warn("Error generating ICS File occured", (Throwable)ex);
                mailConfig.getIcsDefinition().deleteEventFileIfExists();
            }
        }
        return mail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEmail(SMTPConfig smtpConfig, MailConfig mailConfig) throws EmailException {
        try (MDC.MDCCloseable smtp_connection = MDC.putCloseable((String)MDC_SMTP_CONNECTION, (String)String.format("%s:%d", smtpConfig.getSmtpHost(), smtpConfig.getSmtpPort()));
             MDC.MDCCloseable smtp_login = MDC.putCloseable((String)MDC_SMTP_LOGIN, (String)smtpConfig.getSmtpLogin());){
            SimpleEmail mail = switch (mailConfig.getMailType()) {
                case MailType.SIMPLE -> MailSupport.createSimpleMail(smtpConfig, mailConfig);
                case MailType.HTML -> MailSupport.createHtmlEmail(smtpConfig, mailConfig);
                case MailType.MULTIPART -> MailSupport.createMultipartEmail(smtpConfig, mailConfig);
                default -> throw new EmailException(String.format("Email type %s not supported!", new Object[]{mailConfig.getMailType()}));
            };
            LOG.info(String.format("Sending mail type '%s' to '%s'%s%s: '%s'", mailConfig.getMailType().name(), mailConfig.getMailTo(), StringUtils.isNotBlank((CharSequence)mailConfig.getMailCc()) ? String.format(", cc: '%s'", mailConfig.getMailCc()) : "", StringUtils.isNotBlank((CharSequence)mailConfig.getMailBcc()) ? String.format(", bcc: '%s'", mailConfig.getMailBcc()) : "", mailConfig.getMailSubject()));
            try {
                mail.send();
            }
            finally {
                if (mailConfig.getMailType() == MailType.MULTIPART && mailConfig.getIcsDefinition() != null) {
                    mailConfig.getIcsDefinition().deleteEventFileIfExists();
                }
            }
        }
    }

    public static Collection<String> sanitizeAddresses(String[] addresses) {
        LinkedHashSet<String> sanitizedAddresses = new LinkedHashSet<String>();
        for (String currPossibleAddress : Objects.requireNonNull(addresses)) {
            if (!StringUtils.isNotBlank((CharSequence)currPossibleAddress)) continue;
            for (String currAddress : currPossibleAddress.split("\\;")) {
                if (!StringUtils.isNotBlank((CharSequence)currAddress)) continue;
                sanitizedAddresses.add(StringUtils.trimToEmpty((String)currAddress));
            }
        }
        return sanitizedAddresses;
    }
}

