/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.mail;

import de.riwagis.util.exception.SystemException;
import de.riwagis.util.mail.IcsDefinition;
import de.riwagis.util.mail.MailType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.text.TextStringBuilder;

public class MailConfig {
    public static final String PLAIN_TEXT_FM_KEY = "isPlainText";
    public static final String HTML_TEXT_FM_KEY = "isHtml";
    public static final String SUBJECT_TEXT_FM_KEY = "isSubject";
    public static final String TEXT_FM_KEY_LOCALE = "locale";
    public static final String TEXT_FM_KEY_APPLICATIONNAME = "applicationname";
    private final MailType mailType;
    private final String mailTo;
    private final String mailCc;
    private final String mailBcc;
    private final String replyTo;
    private final String mailSubject;
    private final String plainTextMessage;
    private final String htmlMessage;
    private Path mailTemplatePath = null;
    private String applicationName = null;
    private final IcsDefinition icsDefinition;
    private final File[] fileAttachments;
    private final Map<String, Object> templateParams = new LinkedHashMap<String, Object>();

    private MailConfig(MailType mailType, String mailTo, String mailCc, String mailBcc, String mailSubject, String htmlMessage, String plainTextMessage, String replyTo, Path mailTemplatePath, Map<String, Object> templateParams, IcsDefinition icsDefinition, File ... fileAttachments) {
        this.mailType = mailType;
        this.mailTo = mailTo;
        this.mailSubject = mailSubject;
        this.htmlMessage = htmlMessage;
        this.plainTextMessage = plainTextMessage;
        this.replyTo = replyTo;
        this.mailTemplatePath = mailTemplatePath;
        this.mailCc = mailCc;
        this.mailBcc = mailBcc;
        this.icsDefinition = icsDefinition;
        this.fileAttachments = fileAttachments;
        if (templateParams != null) {
            this.templateParams.putAll(templateParams);
        }
    }

    public void addTemplateParam(String key, Object value) {
        this.templateParams.put(key, value);
    }

    public void addTemplateParams(Map<String, Object> params2Add) {
        this.templateParams.putAll(params2Add);
    }

    public Map<String, Object> getTemplateParamCopy() {
        return new LinkedHashMap<String, Object>(this.templateParams);
    }

    public MailType getMailType() {
        return this.mailType;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public String getMailCc() {
        return this.mailCc;
    }

    public String getMailBcc() {
        return this.mailBcc;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public String getPlainTextMessage() {
        return this.plainTextMessage;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public Path getMailTemplatePath() {
        return this.mailTemplatePath;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public IcsDefinition getIcsDefinition() {
        return this.icsDefinition;
    }

    public File[] getFileAttachments() {
        return this.fileAttachments;
    }

    public Map<String, Object> getTemplateParams() {
        return this.templateParams;
    }

    public void setMailTemplatePath(Path mailTemplatePath) {
        this.mailTemplatePath = mailTemplatePath;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String toString() {
        return "MailConfig(mailType=" + this.getMailType() + ", mailTo=" + this.getMailTo() + ", mailCc=" + this.getMailCc() + ", mailBcc=" + this.getMailBcc() + ", replyTo=" + this.getReplyTo() + ", mailSubject=" + this.getMailSubject() + ", plainTextMessage=" + this.getPlainTextMessage() + ", htmlMessage=" + this.getHtmlMessage() + ", mailTemplatePath=" + this.getMailTemplatePath() + ", applicationName=" + this.getApplicationName() + ", icsDefinition=" + this.getIcsDefinition() + ", fileAttachments=" + Arrays.deepToString(this.getFileAttachments()) + ", templateParams=" + this.getTemplateParams() + ")";
    }

    public static class Builder {
        private final MailType mailType;
        private String mailTo = null;
        private String mailCc = null;
        private String mailBcc = null;
        private String replyTo = null;
        private String mailSubject = null;
        private String plainTextMessage = null;
        private String htmlMessage = null;
        private Path mailTemplatePath = null;
        private IcsDefinition icsDefinition = null;
        private File[] fileAttachments = null;
        private Map<String, Object> templateParams = null;

        public Builder(MailType mailType) {
            this.mailType = mailType;
        }

        public Builder addMailTo(String mailTo) {
            this.mailTo = mailTo;
            return this;
        }

        public Builder addMailCc(String mailCc) {
            this.mailCc = mailCc;
            return this;
        }

        public Builder addMailBcc(String mailBcc) {
            this.mailBcc = mailBcc;
            return this;
        }

        public Builder addReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder addMailSubject(String mailSubject) {
            this.mailSubject = mailSubject;
            return this;
        }

        public Builder addHtmlMessage(String htmlMessage) {
            this.htmlMessage = htmlMessage;
            return this;
        }

        public Builder addPlainTextMessage(String plainTextMessage) {
            this.plainTextMessage = plainTextMessage;
            return this;
        }

        public Builder addMailTemplatePath(Path mailTemplatePath) {
            this.mailTemplatePath = mailTemplatePath;
            return this;
        }

        public Builder addIcsDefinition(IcsDefinition icsDefinition) {
            this.icsDefinition = icsDefinition;
            return this;
        }

        public Builder addFileAttachments(File ... fileAttachments) {
            this.fileAttachments = fileAttachments;
            return this;
        }

        public Builder addTemplateParams(Map<String, Object> templateParams) {
            this.templateParams = templateParams;
            return this;
        }

        public MailConfig build() throws SystemException {
            TextStringBuilder errorSb = new TextStringBuilder();
            if (this.mailType == null) {
                Builder.addErrorMessage(errorSb, "\"mailType\" must not be null");
            }
            if (this.mailTo == null) {
                Builder.addErrorMessage(errorSb, "\"mailTo\" must not be null");
            }
            if (this.mailTemplatePath != null && !Files.exists(this.mailTemplatePath, new LinkOption[0])) {
                Builder.addErrorMessage(errorSb, "\"mailTemplatePath %s\" does not exist", this.mailTemplatePath);
            }
            if (this.plainTextMessage == null && this.mailType != MailType.HTML) {
                Builder.addErrorMessage(errorSb, "\"plainTextMessage\" must not be null");
            }
            if (this.htmlMessage == null && this.mailType.isSupportHtmlMessage()) {
                Builder.addErrorMessage(errorSb, "\"htmlMessage\" must not be null");
            }
            if (this.icsDefinition != null && !this.mailType.isSupportAttachments()) {
                Builder.addErrorMessage(errorSb, "\"IcsDefinition\" is not supported for the mailType: %s", this.mailType.name());
            }
            if (this.fileAttachments != null && !this.mailType.isSupportAttachments()) {
                Builder.addErrorMessage(errorSb, "\"File attachments\" are not supported for the mailType: %s", this.mailType.name());
            }
            if (!errorSb.isEmpty()) {
                throw new SystemException(String.format("Could not create MailConfig object due to following error(s): %s", errorSb.toString()));
            }
            return new MailConfig(this.mailType, this.mailTo, this.mailCc, this.mailBcc, this.mailSubject, this.htmlMessage, this.plainTextMessage, this.replyTo, this.mailTemplatePath, this.templateParams, this.icsDefinition, this.fileAttachments);
        }

        private static void addErrorMessage(TextStringBuilder tsb, String errorMessage) {
            tsb.appendSeparator(", ").append(errorMessage);
        }

        private static void addErrorMessage(TextStringBuilder tsb, String format, Object ... params) {
            tsb.appendSeparator(", ").append(format, params);
        }
    }
}

