/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.mail;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.RandomUidGenerator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcsDefinition {
    private static final Logger log = LoggerFactory.getLogger(IcsDefinition.class);
    private static final String PRODUKT_ID = "-//RIWA GmbH//www.riwa-gis.de 1.0//DE";
    private final String eventTitle;
    private final String eventDescription;
    private final String location;
    private final LocalDateTime eventStart;
    private final LocalDateTime eventEnd;
    private final List<Attendee> attendees = new ArrayList<Attendee>();
    private Organizer organizer = null;
    private String attachmentFileName = "termin";
    private Calendar icsCalendar;
    private TimeZone timeZone;
    private VEvent customEvent = null;
    private File tmpEventFile = null;

    public IcsDefinition(VEvent event) {
        this.customEvent = event;
        this.eventTitle = null;
        this.eventDescription = null;
        this.eventStart = null;
        this.eventEnd = null;
        this.location = null;
    }

    public IcsDefinition(String eventTitle, String eventDescription, String location, java.util.Date eventStart, java.util.Date eventEnd) {
        this(eventTitle, eventDescription, location, eventStart, eventEnd, "Europe/Berlin");
    }

    public IcsDefinition(String eventTitle, String eventDescription, String location, LocalDateTime eventStart, LocalDateTime eventEnd) {
        this(eventTitle, eventDescription, location, eventStart, eventEnd, "Europe/Berlin");
    }

    public IcsDefinition(String eventTitle, String eventDescription, String location, LocalDateTime eventStart, LocalDateTime eventEnd, String timeZone) {
        this.initCalendar();
        this.eventTitle = eventTitle;
        this.eventDescription = eventDescription;
        this.location = location;
        this.eventStart = eventStart;
        this.eventEnd = eventEnd;
        this.timeZone = IcsDefinition.createTimezone(timeZone);
    }

    public IcsDefinition(String eventTitle, String eventDescription, String location, java.util.Date eventStart, java.util.Date eventEnd, String timeZone) {
        this.initCalendar();
        this.eventTitle = eventTitle;
        this.eventDescription = eventDescription;
        this.location = location;
        this.timeZone = IcsDefinition.createTimezone(timeZone);
        this.eventStart = eventStart.toInstant().atZone(this.timeZone.toZoneId()).toLocalDateTime();
        this.eventEnd = eventEnd.toInstant().atZone(this.timeZone.toZoneId()).toLocalDateTime();
    }

    private void initCalendar() {
        this.icsCalendar = new Calendar();
        this.icsCalendar.getProperties().add((Property)new ProdId(PRODUKT_ID));
        this.icsCalendar.getProperties().add((Property)Version.VERSION_2_0);
        this.icsCalendar.getProperties().add((Property)CalScale.GREGORIAN);
    }

    private java.util.Calendar createEventTime(LocalDateTime eventDateTime, TimeZone timezone) {
        GregorianCalendar startDate = new GregorianCalendar();
        ((java.util.Calendar)startDate).setTimeZone((java.util.TimeZone)timezone);
        startDate.set(2, eventDateTime.getMonthValue() - 1);
        startDate.set(5, eventDateTime.getDayOfMonth());
        startDate.set(1, eventDateTime.getYear());
        startDate.set(11, eventDateTime.getHour());
        startDate.set(12, eventDateTime.getMinute());
        startDate.set(13, eventDateTime.getSecond());
        return startDate;
    }

    public VEvent createEvent() {
        if (this.customEvent != null) {
            return this.customEvent;
        }
        DateTime start = new DateTime(this.createEventTime(this.eventStart, this.timeZone).getTime());
        DateTime end = new DateTime(this.createEventTime(this.eventEnd, this.timeZone).getTime());
        VEvent event = new VEvent((Date)start, (Date)end, this.eventTitle);
        event.getProperties().add((Property)new RandomUidGenerator().generateUid());
        event.getProperties().add((Property)new Description(this.eventDescription));
        event.getProperties().add((Property)new Location(this.location));
        event.getProperties().add((Property)Clazz.PUBLIC);
        event.getProperties().add((Property)Method.PUBLISH);
        if (!this.attendees.isEmpty()) {
            event.getProperties().addAll(this.attendees);
        }
        if (this.organizer != null) {
            event.getProperties().add((Property)this.organizer);
        }
        return event;
    }

    public File createEventFile() {
        return this.createEventFile(this.createEvent());
    }

    public File createEventFile(VEvent event) {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            File tmpFile = Paths.get(tmpDir, UUID.randomUUID().toString(), String.format("%s.ics", this.attachmentFileName != null ? this.attachmentFileName : "termin")).toFile();
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            tmpFile.getParentFile().mkdirs();
            try (FileOutputStream fout = new FileOutputStream(tmpFile);){
                this.icsCalendar.getComponents().clear();
                this.icsCalendar.getComponents().add((Object)event);
                CalendarOutputter outputter = new CalendarOutputter();
                outputter.output(this.icsCalendar, (OutputStream)fout);
            }
            this.tmpEventFile = tmpFile;
            return tmpFile;
        }
        catch (IOException ex) {
            log.error("Could not write the .ics file", (Throwable)ex);
            this.tmpEventFile = null;
            return null;
        }
    }

    public static File createCustomEventFile(VEvent event) {
        IcsDefinition icsDefinition = new IcsDefinition(event);
        return icsDefinition.createEventFile();
    }

    public String getEventString() {
        VEvent event = this.createEvent();
        this.icsCalendar.getComponents().add((Object)event);
        return this.icsCalendar.toString();
    }

    public TimeZone createDefaultEuropeTimezone() {
        return IcsDefinition.createTimezone("Europe/Berlin");
    }

    public static TimeZone createTimezone(String timeZoneId) {
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        TimeZone timezone = registry.getTimeZone(timeZoneId);
        return timezone;
    }

    public void addAttendee(String emailAddress, String name, boolean optional) {
        if (emailAddress != null) {
            Attendee a = new Attendee(URI.create(String.format("mailto:%s", emailAddress)));
            a.getParameters().add((Parameter)(optional ? Role.OPT_PARTICIPANT : Role.REQ_PARTICIPANT));
            if (name != null) {
                a.getParameters().add((Parameter)new Cn(name));
            }
            this.attendees.add(a);
        }
    }

    public void deleteEventFileIfExists() {
        if (this.tmpEventFile != null && this.tmpEventFile.getParentFile().exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpEventFile.getParentFile());
            }
            catch (IOException ex) {
                log.warn("Could not delete the temp .isc directory {}", (Object)this.tmpEventFile.getParent());
            }
            this.tmpEventFile = null;
        }
    }

    public void setOrganizer(String email, String name) {
        this.organizer = new Organizer(URI.create(String.format("mailto:%s", email)));
        this.organizer.getParameters().add((Parameter)new Cn(name));
    }

    public void setAttachmentFileName(String attachmentFileName) {
        this.attachmentFileName = attachmentFileName;
    }

    public static void main(String[] args) {
        IcsDefinition def = new IcsDefinition("TestTermin", "In diesem Termin wird blablabla", "B\u00fcro gro\u00df", LocalDateTime.now(), LocalDateTime.now().plusHours(5L));
        def.createEventFile();
    }
}

