/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.mail;

import de.riwagis.util.Config;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.mail.EmailException;

public class FreemarkerSupport {
    private static final String TEMPLATE_NAME = "template";

    public static Configuration getConfiguration(String template) {
        return FreemarkerSupport.getConfiguration(template, Config.LOCALE);
    }

    public static Configuration getConfiguration(String template, Locale locale) {
        return FreemarkerSupport.createConfiguration(template, locale, "UTF-8");
    }

    public static Configuration createConfiguration(String template, Locale locale, String encoding) {
        Configuration config = new Configuration(Configuration.VERSION_2_3_29);
        config.setDefaultEncoding(encoding);
        config.setLocale(locale);
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setLogTemplateExceptions(false);
        config.setWrapUncheckedExceptions(true);
        config.setTagSyntax(2);
        StringTemplateLoader stl = new StringTemplateLoader();
        stl.putTemplate(TEMPLATE_NAME, template);
        config.setTemplateLoader((TemplateLoader)stl);
        return config;
    }

    public static Template getTemplate(Configuration config) throws Exception {
        return config.getTemplate(TEMPLATE_NAME);
    }

    public static String processTemplate(Path templatePath, Map<String, Object> params) throws EmailException {
        try {
            Configuration config = FreemarkerSupport.getConfiguration(new String(Files.readAllBytes(templatePath), StandardCharsets.UTF_8));
            StringWriter fmStringWriter = new StringWriter(100);
            FreemarkerSupport.getTemplate(config).process(params, (Writer)fmStringWriter);
            return fmStringWriter.toString();
        }
        catch (Exception ex) {
            throw new EmailException("Error occured in processing freemarker template", (Throwable)ex);
        }
    }
}

