/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.logging;

import java.io.File;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogSupport {
    private static final Logger LOG = LoggerFactory.getLogger(LogSupport.class);
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;

    @Deprecated
    public static void initBasicLogging() {
    }

    private LogSupport() {
    }

    public static void addXMLConfigurationFile(String strFileName) {
        LOG.info(MessageFormat.format("Initialize Logging. Using configuration file: ''{0}''", strFileName));
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        File file = new File(strFileName);
        context.setConfigLocation(file.toURI());
    }

    public static Logger getLogger(Class<?> cls) {
        return LoggerFactory.getLogger(cls);
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static Logger getRootLogger() {
        return LoggerFactory.getLogger((String)"");
    }

    public static void log(int level, String message) {
        LogSupport.log(LogSupport.getRootLogger(), level, message);
    }

    public static void log(String name, int level, String message) {
        LogSupport.log(LogSupport.getLogger(name), level, message);
    }

    public static void log(Class<?> cls, int level, String message) {
        LogSupport.log(LogSupport.getLogger(cls), level, message);
    }

    private static void log(Logger logger, int level, String message) {
        switch (level) {
            case 1: {
                logger.debug(message);
                break;
            }
            case 2: {
                logger.info(message);
                break;
            }
            case 3: {
                logger.warn(message);
                break;
            }
            case 4: {
                logger.error(message);
                break;
            }
            case 5: {
                logger.error(message);
            }
        }
    }
}

