/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.pool.debugging;

import de.riwagis.util.jdbc.pool.JDBCPool;
import de.riwagis.util.jdbc.pool.debugging.DBConnInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.PooledObjectState;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPoolSessionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCPoolSessionUtils.class);

    public static Collection<DBConnInfo> readPooledConnections() throws SQLException {
        ArrayList<DBConnInfo> dbConns = new ArrayList<DBConnInfo>();
        for (String retrievePoolName : JDBCPool.retrievePoolNames()) {
            dbConns.addAll(JDBCPoolSessionUtils.readPooledConnections(retrievePoolName));
        }
        return dbConns;
    }

    public static Collection<DBConnInfo> readPooledConnections(String poolid) throws SQLException {
        DataSource ds2 = JDBCPool.getDataSourceByAlias(poolid);
        ArrayList<DBConnInfo> dbConns = new ArrayList<DBConnInfo>();
        if (ds2 instanceof SharedPoolDataSource) {
            try {
                KeyedObjectPool objectPool = (KeyedObjectPool)FieldUtils.readField((Object)ds2, (String)"pool", (boolean)true);
                LOG.debug("pool: " + objectPool);
                if (objectPool != null) {
                    Map poolMap = (Map)FieldUtils.readField((Object)objectPool, (String)"poolMap", (boolean)true);
                    JDBCPoolSessionUtils.logMap(poolMap);
                    for (Map.Entry entry : poolMap.entrySet()) {
                        Object objDeque = entry.getValue();
                        Map allObjects = (Map)FieldUtils.readDeclaredField(objDeque, (String)"allObjects", (boolean)true);
                        JDBCPoolSessionUtils.logMap(allObjects);
                        for (Map.Entry entry1 : allObjects.entrySet()) {
                            DefaultPooledObject defConnAndInfo = (DefaultPooledObject)entry1.getValue();
                            Object pooledConnectionAndInfo = defConnAndInfo.getObject();
                            PooledConnection pc = (PooledConnection)FieldUtils.readField((Object)pooledConnectionAndInfo, (String)"pooledConnection", (boolean)true);
                            LOG.debug(String.format("%s (%s)", pc, pc.getClass()));
                            Connection currLogicalConn = (Connection)FieldUtils.readField((Object)pc, (String)"logicalConnection", (boolean)true);
                            Connection currPhysicalConn = (Connection)FieldUtils.readField((Object)pc, (String)"connection", (boolean)true);
                            PooledObjectState state = defConnAndInfo.getState();
                            if (!currPhysicalConn.isClosed()) {
                                DBConnInfo latestAdjustedSchema = JDBCPool.retrieveLatestAdjustedSchema(currLogicalConn);
                                String schemaName = latestAdjustedSchema != null ? latestAdjustedSchema.getSchema() : null;
                                dbConns.add(new DBConnInfo(currPhysicalConn.getMetaData().getURL(), currPhysicalConn.getMetaData().getUserName(), state, schemaName));
                                continue;
                            }
                            if (state != PooledObjectState.ALLOCATED) continue;
                            LOG.warn("allocated closed connection: " + currPhysicalConn);
                        }
                    }
                }
            }
            catch (IllegalAccessException ex) {
                LOG.error(String.format("error retrieving pooled connections: %s", ex.getMessage()), (Throwable)ex);
            }
        }
        return dbConns;
    }

    public static void logMap(Map<?, ?> allObjects) {
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<?, ?> currEntry : allObjects.entrySet()) {
                LOG.debug(String.format("%s (%s) --> %s (%s)", currEntry.getKey(), currEntry.getKey().getClass(), currEntry.getValue(), currEntry.getValue().getClass()));
            }
        }
    }
}

