/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface SchemaAdjust {
    public static final Logger LOG = LoggerFactory.getLogger(SchemaAdjust.class);
    public static final SchemaAdjust SCHEMAADJUST_NULL = new SchemaAdjust(){

        @Override
        public void adjustSchema(Connection conn, String schema) throws SQLException {
            LOG.debug(String.format("schema on connection '%s' not changed: '%s'", conn, schema));
        }
    };
    public static final SchemaAdjust SCHEMAADJUST_POSTGRES = new SchemaAdjust(){

        @Override
        public void adjustSchema(Connection conn, String strDefaultTablespace) throws SQLException {
            if (StringUtils.isNotEmpty((CharSequence)strDefaultTablespace)) {
                try (Statement stmt = conn.createStatement();){
                    stmt.executeUpdate(String.format("SET search_path TO %s,\"$user\",public", strDefaultTablespace));
                }
            }
        }
    };
    public static final SchemaAdjust SCHEMAADJUST_CATALOG = new SchemaAdjust(){

        @Override
        public void adjustSchema(Connection conn, String strDefaultTablespace) throws SQLException {
            if (StringUtils.isNotEmpty((CharSequence)strDefaultTablespace)) {
                conn.setCatalog(strDefaultTablespace);
            }
        }
    };
    public static final SchemaAdjust SCHEMAADJUST_ORACLE = new SchemaAdjust(){

        @Override
        public void adjustSchema(Connection conn, String strDefaultTablespace) throws SQLException {
            String connUserName;
            if (StringUtils.isNotEmpty((CharSequence)strDefaultTablespace) && !StringUtils.equalsIgnoreCase((CharSequence)(connUserName = conn.getMetaData().getUserName()), (CharSequence)strDefaultTablespace)) {
                LOG.warn(String.format("Different user and tableschema name ('%s' != '%s' ) are not supported when using an oracle database", connUserName, strDefaultTablespace));
            }
        }
    };

    public void adjustSchema(Connection var1, String var2) throws SQLException;
}

