/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.pool;

import de.riwagis.util.jdbc.pool.DBDriver;
import de.riwagis.util.jdbc.pool.DBDriverParameter;
import de.riwagis.util.jdbc.pool.JDBCPoolException;
import de.riwagis.util.jdbc.pool.JDBCPoolInformation;
import de.riwagis.util.jdbc.pool.debugging.DBConnInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPool {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCPool.class);
    private static final Map<String, DataSource> mapPools = new LinkedHashMap<String, DataSource>();
    private static final Map<String, String> mapAliasURL = new LinkedHashMap<String, String>();
    private static final Map<String, DBDriver> mapAliasDriver = new LinkedHashMap<String, DBDriver>();
    private static final ReadWriteLock poolLock = new ReentrantReadWriteLock();
    private static final int DEFAULT_KEEP_ALIVE_TIME_IDLE_CONNECTION = 14400;
    private static final boolean DEFAULT_TESTONBORROW = true;
    private static final Map<Connection, DBConnInfo> schemaNames = Collections.synchronizedMap(new WeakHashMap());

    public static Collection<String> retrievePoolNames() {
        return new LinkedHashSet<String>(mapPools.keySet());
    }

    public static int latestAdjustedSchemaCount() {
        if (LOG.isDebugEnabled()) {
            ArrayList<String> connSchemaNames = new ArrayList<String>();
            for (DBConnInfo currConnInfo : schemaNames.values()) {
                connSchemaNames.add(String.format("%s @ %s - %s", currConnInfo.getUsername(), currConnInfo.getUrl(), currConnInfo.getSchema()));
            }
            LOG.debug("schema names: " + StringUtils.join(connSchemaNames, (String)", "));
        }
        return schemaNames.size();
    }

    @Deprecated
    public static void registerSharedPool(String strAlias, String driverName, String strUrl, String defaultUser, String defaultPwd, int maxActive, int maxIdle, int maxWaitMSec) throws JDBCPoolException {
        JDBCPool.registerPool((DataSource)new SharedPoolDataSource(), strAlias, driverName, strUrl, defaultUser, defaultPwd, maxActive, maxIdle, maxWaitMSec, 14400, true);
    }

    public static void registerSharedPool(String strAlias, String driverName, String strUrl, String defaultUser, String defaultPwd, int maxActive, int maxIdle, int maxWaitMSec, int keepAliveTimeIdleSec, boolean testOnBorrow) throws JDBCPoolException {
        JDBCPool.registerPool((DataSource)new SharedPoolDataSource(), strAlias, driverName, strUrl, defaultUser, defaultPwd, maxActive, maxIdle, maxWaitMSec, keepAliveTimeIdleSec, testOnBorrow);
    }

    @Deprecated
    public static void registerPool(DataSource tds, String strAlias, String driverName, String strUrl, String defaultUser, String defaultPwd, int maxActive, int maxIdle, int maxWaitMSec) throws JDBCPoolException {
        JDBCPool.registerPool(tds, strAlias, driverName, strUrl, defaultUser, defaultPwd, maxActive, maxIdle, maxWaitMSec, 14400, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPool(DataSource tds, String dbAlias, String driverName, String dbUrl, String defaultUser, String defaultPwd, int maxActive, int maxIdle, int maxWaitMSec, int keepAliveTimeIdleSec, boolean testOnBorrow) throws JDBCPoolException {
        if (maxActive <= 0) {
            throw new IllegalArgumentException(String.format("pool must allow active connections (%s is too small)", maxActive));
        }
        poolLock.writeLock().lock();
        try {
            if (mapPools.get(dbAlias) != null) {
                throw new JDBCPoolException(String.format("%s : Pool is already registered", dbAlias));
            }
            DriverAdapterCPDS cpds = new DriverAdapterCPDS();
            try {
                cpds.setDriver(driverName);
            }
            catch (ClassNotFoundException clsnfEx) {
                throw new JDBCPoolException(String.format("Driver class not found: %s", driverName), clsnfEx);
            }
            cpds.setUrl(dbUrl);
            cpds.setUser(defaultUser);
            cpds.setPassword(defaultPwd);
            cpds.setLoginTimeout(10);
            cpds.setPoolPreparedStatements(false);
            cpds.setAccessToUnderlyingConnectionAllowed(true);
            DBDriver drv = DBDriver.findByClassName(driverName);
            Properties props = new Properties();
            for (DBDriverParameter driverParameter : drv.getDriverParameters()) {
                if (!driverParameter.getCondition().allowExecute()) continue;
                props.setProperty(driverParameter.getName(), driverParameter.getValue());
            }
            cpds.setConnectionProperties(props);
            if (tds instanceof InstanceKeyDataSource) {
                InstanceKeyDataSource ids = (InstanceKeyDataSource)tds;
                ids.setDefaultAutoCommit(Boolean.valueOf(true));
                ids.setConnectionPoolDataSource((ConnectionPoolDataSource)cpds);
                ids.setDefaultTestOnBorrow(testOnBorrow);
                ids.setDefaultTestOnReturn(testOnBorrow);
                ids.setLoginTimeout(10);
                ids.setDefaultTimeBetweenEvictionRunsMillis(60000L);
                ids.setDefaultNumTestsPerEvictionRun(20);
                ids.setDefaultMinEvictableIdleTimeMillis((long)(keepAliveTimeIdleSec * 1000));
                if (testOnBorrow) {
                    ids.setValidationQuery(drv.getValidationQuery());
                }
                ids.setDefaultMaxTotal(maxActive);
                ids.setDefaultMaxIdle(maxIdle);
                ids.setDefaultMaxWaitMillis((long)maxWaitMSec);
            }
            mapPools.put(dbAlias, tds);
            mapAliasURL.put(dbAlias, dbUrl);
            mapAliasDriver.put(dbAlias, drv);
        }
        finally {
            poolLock.writeLock().unlock();
        }
    }

    @Deprecated
    public static void registerPerUserPool(String strAlias, String driverName, String strUrl, String defaultUser, String defaultPwd, int maxActive, int maxIdle, int maxWaitMSec) throws JDBCPoolException {
        JDBCPool.registerPool((DataSource)new PerUserPoolDataSource(), strAlias, driverName, strUrl, defaultUser, defaultPwd, maxActive, maxIdle, maxWaitMSec, 14400, true);
    }

    public static void registerPerUserPool(String dbAlias, String driverName, String dbUrl, String defaultUser, String defaultPwd, int maxActive, int maxIdle, int maxWaitMSec, int keepAliveTimeIdleSec, boolean testOnBorrow) throws JDBCPoolException {
        JDBCPool.registerPool((DataSource)new PerUserPoolDataSource(), dbAlias, driverName, dbUrl, defaultUser, defaultPwd, maxActive, maxIdle, maxWaitMSec, keepAliveTimeIdleSec, testOnBorrow);
    }

    public static Connection getConnAlias(String dbAlias, String dbUser, String dbPwd) throws JDBCPoolException {
        return JDBCPool.getConnAlias(dbAlias, dbUser, dbPwd, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getConnAlias(String dbAlias, String dbUser, String dbPwd, String defaultTablespace) throws JDBCPoolException {
        poolLock.readLock().lock();
        try {
            if (!mapPools.containsKey(dbAlias)) throw new JDBCPoolException(String.format("Error retrieving connection. Alias: '%s' not found.", dbAlias));
            DBDriver drv = mapAliasDriver.get(dbAlias);
            if (drv == null) {
                drv = DBDriver.Unknown;
            }
            DataSource pool = mapPools.get(dbAlias);
            Connection conn = pool.getConnection(dbUser, dbPwd);
            try {
                if (drv != DBDriver.Unknown) {
                    JDBCPool.adjustConnectionToDBType(conn, drv, defaultTablespace);
                    schemaNames.put(conn, new DBConnInfo(mapAliasURL.get(dbAlias), dbUser, PooledObjectState.INVALID, defaultTablespace));
                }
                Connection connection = conn;
                return connection;
            }
            catch (SQLException sqlex) {
                try {
                    DbUtils.closeQuietly((Connection)conn);
                    throw sqlex;
                }
                catch (SQLException sqlEx) {
                    throw new JDBCPoolException(String.format("Error retrieving connection. URL: '%s', User: '%s', Schema: '%s': %s", mapAliasURL.get(dbAlias), dbUser, defaultTablespace, sqlEx.getMessage()), sqlEx);
                }
            }
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    @Deprecated
    public static Connection getConnUrl(String dbUrl, String dbUser, String dbPwd) throws JDBCPoolException {
        return JDBCPool.getConnUrl(dbUrl, dbUser, dbPwd, null);
    }

    private static String getAlias4URL(String dbUrl) {
        for (Map.Entry<String, String> entry : mapAliasURL.entrySet()) {
            if (!entry.getValue().equals(dbUrl)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Deprecated
    public static Connection getConnUrl(String dbUrl, String dbUser, String dbPwd, String defaultTablespace) throws JDBCPoolException {
        poolLock.readLock().lock();
        try {
            String strAlias = JDBCPool.getAlias4URL(dbUrl);
            if (StringUtils.isNotBlank((CharSequence)strAlias)) {
                Connection connection = JDBCPool.getConnAlias(strAlias, dbUser, dbPwd, defaultTablespace);
                return connection;
            }
            throw new JDBCPoolException(String.format("Error retrieving connection. URL: '%s' not found.", dbUrl));
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    public static DataSource getDataSourceByAlias(String dbAlias) {
        poolLock.readLock().lock();
        try {
            DataSource dataSource = mapPools.get(dbAlias);
            return dataSource;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    @Deprecated
    public static DataSource getDataSourceByUrl(String dbUrl) {
        poolLock.readLock().lock();
        try {
            String dbAlias = JDBCPool.getAlias4URL(dbUrl);
            DataSource dataSource = mapPools.get(dbAlias);
            return dataSource;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    @Deprecated
    public static boolean hasUrl(String dbUrl) {
        poolLock.readLock().lock();
        try {
            String dbAlias = JDBCPool.getAlias4URL(dbUrl);
            boolean bl = dbAlias != null;
            return bl;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    public static boolean hasAlias(String dbAlias) {
        poolLock.readLock().lock();
        try {
            boolean bl = mapPools.get(dbAlias) != null;
            return bl;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    private static void adjustConnectionToDBType(Connection conn, DBDriver drv, String strDefaultTablespace) throws SQLException {
        if (StringUtils.isNotEmpty((CharSequence)strDefaultTablespace)) {
            drv.adjustConnectionToDBType(conn, strDefaultTablespace);
        }
    }

    public static DBConnInfo retrieveLatestAdjustedSchema(Connection conn) {
        return schemaNames.get(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JDBCPoolInformation> getPoolInformation() {
        poolLock.readLock().lock();
        try {
            ArrayList<JDBCPoolInformation> poolInfo = new ArrayList<JDBCPoolInformation>(mapPools.size());
            for (String strAlias : mapPools.keySet()) {
                SharedPoolDataSource ds;
                if (mapPools.get(strAlias) instanceof SharedPoolDataSource) {
                    ds = (SharedPoolDataSource)mapPools.get(strAlias);
                    poolInfo.add(new JDBCPoolInformation(strAlias, mapAliasURL.get(strAlias), 1, ds.getNumActive(), ds.getDefaultMaxTotal(), ds.getNumIdle(), ds.getDefaultMaxIdle(), ds.getDefaultMinEvictableIdleTimeMillis() / 1000L, ds.getDefaultTestOnBorrow()));
                    continue;
                }
                ds = (PerUserPoolDataSource)mapPools.get(strAlias);
                poolInfo.add(new JDBCPoolInformation(strAlias, mapAliasURL.get(strAlias), 2, ds.getNumActive(), -1, ds.getNumIdle(), -1, ds.getDefaultMinEvictableIdleTimeMillis() / 1000L, ds.getDefaultTestOnBorrow()));
            }
            ArrayList<JDBCPoolInformation> arrayList = poolInfo;
            return arrayList;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPoolInfoText() {
        poolLock.readLock().lock();
        try {
            StringBuilder sbInfo = new StringBuilder();
            for (String strAlias : mapPools.keySet()) {
                SharedPoolDataSource ds;
                if (mapPools.get(strAlias) instanceof SharedPoolDataSource) {
                    ds = (SharedPoolDataSource)mapPools.get(strAlias);
                    sbInfo.append("\nDatenbank (SharedPool): ").append(strAlias).append("\n");
                    sbInfo.append("URL: ").append(mapAliasURL.get(strAlias)).append("\n");
                    sbInfo.append("Aktuell verwendete Verbindungen: ").append(JDBCPool.buildConnText(ds.getNumActive(), ds.getDefaultMaxTotal())).append("\n");
                    sbInfo.append("Ge\u00f6ffnete Verbindungen: ").append(JDBCPool.buildConnText(ds.getNumIdle(), ds.getDefaultMaxIdle())).append("\n");
                    sbInfo.append("Vorhaltezeitraum (sek.): ").append(ds.getDefaultMinEvictableIdleTimeMillis() / 1000L).append("\n");
                    sbInfo.append("Vor Verwendung pr\u00fcfen: ").append(ds.getDefaultTestOnBorrow()).append("\n");
                    continue;
                }
                ds = (PerUserPoolDataSource)mapPools.get(strAlias);
                sbInfo.append("\n\nDatenbank (PerUserPool): ").append(strAlias).append("\n");
                sbInfo.append("URL: ").append(mapAliasURL.get(strAlias)).append("\n");
                sbInfo.append("Aktuell verwendete Verbindungen: ").append(ds.getNumActive()).append("\n");
                sbInfo.append("Ge\u00f6ffnete Verbindungen: ").append(ds.getNumIdle()).append("\n");
                sbInfo.append("Vorhaltezeitraum (sek.): ").append(ds.getDefaultMinEvictableIdleTimeMillis() / 1000L).append("\n");
                sbInfo.append("Vor Verwendung pr\u00fcfen: ").append(ds.getDefaultTestOnBorrow()).append("\n");
            }
            String string = sbInfo.toString();
            return string;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getPoolInfo() {
        poolLock.readLock().lock();
        try {
            StringBuilder sbInfo = new StringBuilder();
            for (String strAlias : mapPools.keySet()) {
                SharedPoolDataSource ds;
                if (mapPools.get(strAlias) instanceof SharedPoolDataSource) {
                    ds = (SharedPoolDataSource)mapPools.get(strAlias);
                    sbInfo.append("<table>");
                    sbInfo.append("<tr><th>Datenbank (SharedPool):</th><td>").append(strAlias).append("</td></tr>");
                    sbInfo.append("<tr><th>URL:</th><td>").append(mapAliasURL.get(strAlias)).append("</td></tr>");
                    sbInfo.append("<tr><th>Aktuell verwendete Verbindungen</th><td>").append(JDBCPool.buildConnText(ds.getNumActive(), ds.getDefaultMaxTotal())).append("</td></tr>");
                    sbInfo.append("<tr><th>Ge\u00f6ffnete Verbindungen</th><td>").append(JDBCPool.buildConnText(ds.getNumIdle(), ds.getDefaultMaxIdle())).append("</td></tr>");
                    sbInfo.append("<tr><th>Vorhaltezeitraum (sek.):</th><td>").append(ds.getDefaultMinEvictableIdleTimeMillis() / 1000L).append("</td></tr>");
                    sbInfo.append("<tr><th>Vor Verwendung pr\u00fcfen:</th><td>").append(ds.getDefaultTestOnBorrow()).append("</td></tr>");
                    sbInfo.append("</table><br>");
                    continue;
                }
                ds = (PerUserPoolDataSource)mapPools.get(strAlias);
                sbInfo.append("<table><tr><th>Datenbank (PerUserPool):</th><td>").append(strAlias).append("</td></tr>");
                sbInfo.append("<tr><th>URL:</th><td>").append(mapAliasURL.get(strAlias)).append("</td></tr>");
                sbInfo.append("<tr><td>Aktuell verwendete Verbindungen:</th><td>").append(ds.getNumActive()).append("</td></tr>");
                sbInfo.append("<tr><td>Ge\u00f6ffnete Verbindungen:</th><td>").append(ds.getNumIdle()).append("</td></tr>");
                sbInfo.append("<tr><th>Vorhaltezeitraum (sek.):</th><td>").append(ds.getDefaultMinEvictableIdleTimeMillis() / 1000L).append("</td></tr>");
                sbInfo.append("<tr><th>Vor Verwendung pr\u00fcfen:</th><td>").append(ds.getDefaultTestOnBorrow()).append("</td></tr>");
                sbInfo.append("</table><br>");
            }
            String string = sbInfo.toString();
            return string;
        }
        finally {
            poolLock.readLock().unlock();
        }
    }

    public static void removePool(String alias) throws Exception {
        poolLock.writeLock().lock();
        try {
            if (mapPools.containsKey(alias)) {
                if (mapPools.get(alias) instanceof SharedPoolDataSource) {
                    SharedPoolDataSource ds = (SharedPoolDataSource)mapPools.get(alias);
                    ds.close();
                } else {
                    PerUserPoolDataSource ds = (PerUserPoolDataSource)mapPools.get(alias);
                    ds.close();
                }
                mapPools.remove(alias);
                mapAliasURL.remove(alias);
                mapAliasDriver.remove(alias);
            }
        }
        finally {
            poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPools() throws JDBCPoolException {
        poolLock.writeLock().lock();
        try {
            for (String dbAlias : mapPools.keySet()) {
                SharedPoolDataSource ds;
                if (mapPools.get(dbAlias) instanceof SharedPoolDataSource) {
                    ds = (SharedPoolDataSource)mapPools.get(dbAlias);
                    try {
                        ds.close();
                        continue;
                    }
                    catch (Exception ex) {
                        throw new JDBCPoolException(String.format("unable to close sharedpool '%s': %s", dbAlias, ex.getMessage()), ex);
                    }
                }
                ds = (PerUserPoolDataSource)mapPools.get(dbAlias);
                ds.close();
            }
            mapPools.clear();
            mapAliasURL.clear();
            mapAliasDriver.clear();
        }
        finally {
            poolLock.writeLock().unlock();
        }
    }

    static String buildConnText(int currentValue, int maxValue) {
        return String.format("%d ( bei max. %d Verbindungen pro DB-Benutzer )", currentValue, maxValue);
    }
}

