/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.pool;

import de.riwagis.util.jdbc.pool.DBDriverCondition;
import de.riwagis.util.jdbc.pool.DBDriverHint;
import de.riwagis.util.jdbc.pool.HintCondition;
import org.apache.commons.lang3.StringUtils;

public class DBDriverParameter {
    public static final DBDriverParameter DBDRVPARAM_MYSQL_TINYINT1ISBIT = new DBDriverParameter(new HintCondition(DBDriverHint.HINT_MYSQL_TINYINT_NOTBIT), "tinyInt1isBit", "false");
    private final String name;
    private final String value;
    private DBDriverCondition condition;

    public DBDriverParameter(DBDriverCondition condition, String name, String value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("dbdriver parameter must not be null/empty/blank.");
        }
        if (condition == null) {
            throw new NullPointerException("condition must not be null");
        }
        this.name = name;
        this.value = value;
        this.condition = condition;
    }

    public DBDriverParameter(String name, String value) {
        this(DBDriverCondition.CONDITION_ALWAYS, name, value);
    }

    public DBDriverCondition getCondition() {
        return this.condition;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format(String.format("parameter '%s'='%s'", this.getName(), this.getValue()), new Object[0]);
    }
}

