/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc.pool;

import de.riwagis.util.jdbc.pool.DBDriverHint;
import de.riwagis.util.jdbc.pool.DBDriverParameter;
import de.riwagis.util.jdbc.pool.SchemaAdjust;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum DBDriver {
    Unknown("unknown", "SELECT 1", "", SchemaAdjust.SCHEMAADJUST_NULL, new DBDriverParameter[0]),
    Oracle("oracle.jdbc.driver.OracleDriver", "SELECT 1 FROM DUAL", "ORACLE", SchemaAdjust.SCHEMAADJUST_ORACLE, new DBDriverParameter("defaultRowPrefetch", "10"), new DBDriverParameter("oracle.jdbc.useThreadLocalBufferCache", "true"), new DBDriverParameter("oracle.jdbc.maxCachedBufferSize", "18")),
    MySQL("com.mysql.jdbc.Driver", "SELECT 1", "MYSQL", SchemaAdjust.SCHEMAADJUST_CATALOG, DBDriverParameter.DBDRVPARAM_MYSQL_TINYINT1ISBIT, new DBDriverParameter("nullDatabaseMeansCurrent", "true")),
    MariaDB("org.mariadb.jdbc.Driver", "SELECT 1", "MARIADB", SchemaAdjust.SCHEMAADJUST_CATALOG, DBDriverParameter.DBDRVPARAM_MYSQL_TINYINT1ISBIT, new DBDriverParameter("nullDatabaseMeansCurrent", "true")),
    Postgres("org.postgresql.Driver", "SELECT 1", "POSTGRESQL", SchemaAdjust.SCHEMAADJUST_POSTGRES, new DBDriverParameter[0]),
    MSSQLServer("com.microsoft.sqlserver.jdbc.SQLServerDriver", "SELECT 1", "Microsoft ?SQL ?Server|sqlserver", SchemaAdjust.SCHEMAADJUST_CATALOG, new DBDriverParameter[0]),
    HSQL("org.hsqldb.jdbc.JDBCDriver", "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS", ".*HSQL.*", SchemaAdjust.SCHEMAADJUST_CATALOG, new DBDriverParameter[0]);

    private static final Collection<DBDriverHint> hints;
    private final String validationQuery;
    private final String driverClassName;
    private final SchemaAdjust schemaAdjust;
    private final Pattern productNamePattern;
    private final Collection<DBDriverParameter> driverParamters = new LinkedHashSet<DBDriverParameter>();

    public static DBDriverHint getHint(String hintName) {
        for (DBDriverHint hint : hints) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)hintName, (CharSequence)hint.getHintName())) continue;
            return hint;
        }
        return null;
    }

    public static void setDBDriverHint(DBDriverHint hint) {
        if (hint == null) {
            throw new NullPointerException("null hint not allowed.");
        }
        hints.add(hint);
    }

    public static void removeDBDriverHint(DBDriverHint hint) {
        if (hint == null) {
            throw new NullPointerException("null hint not allowed.");
        }
        hints.remove(hint);
    }

    public static final DBDriver findByProductName(String databaseProductName) {
        if (StringUtils.isNotBlank((CharSequence)databaseProductName)) {
            for (DBDriver currDBProduct : DBDriver.values()) {
                Pattern productNamePattern = currDBProduct.getProductNamePattern();
                if (productNamePattern == null || !productNamePattern.matcher(databaseProductName).matches()) continue;
                return currDBProduct;
            }
        }
        return Unknown;
    }

    private DBDriver(String driverClass, String validationQuery, String productNamePattern, SchemaAdjust schemaAdjust, DBDriverParameter ... parameters) {
        if (driverClass == null) {
            throw new NullPointerException("typeIdentifier must not be null");
        }
        this.driverClassName = driverClass;
        this.validationQuery = validationQuery;
        this.schemaAdjust = schemaAdjust;
        this.productNamePattern = DBDriver.compilePattern(productNamePattern, 2);
        if (parameters != null) {
            this.driverParamters.addAll(Arrays.asList(parameters));
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public boolean hasDriverClassName(String className) {
        return this.getDriverClassName().equalsIgnoreCase(className);
    }

    public static DBDriver findByClassName(String className) {
        DBDriver res = Unknown;
        for (DBDriver currType : DBDriver.values()) {
            if (!currType.hasDriverClassName(className)) continue;
            res = currType;
        }
        return res;
    }

    public final String getValidationQuery() {
        return this.validationQuery;
    }

    private Pattern getProductNamePattern() {
        return this.productNamePattern;
    }

    public void adjustConnectionToDBType(Connection conn, String schemaName) throws SQLException {
        if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
            this.schemaAdjust.adjustSchema(conn, schemaName);
        }
    }

    public static Pattern compilePattern(String regexPattern, int flags) {
        return StringUtils.isNotBlank((CharSequence)regexPattern) ? Pattern.compile(regexPattern, flags) : null;
    }

    public Collection<DBDriverParameter> getDriverParameters() {
        return Collections.unmodifiableCollection(this.driverParamters);
    }

    static {
        hints = new LinkedHashSet<DBDriverHint>();
    }
}

