/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.AbstractListHandler;
import org.apache.commons.lang3.ObjectUtils;

public class MapListStringHandler
extends AbstractListHandler<Map<String, String>> {
    private static final RowProcessor DEFAULT_ROW_PROCESSOR = new BasicRowProcessor();
    private final RowProcessor usedRowProcessor;

    public MapListStringHandler(RowProcessor usedRowProcessor) {
        this.usedRowProcessor = usedRowProcessor;
    }

    public MapListStringHandler() {
        this(DEFAULT_ROW_PROCESSOR);
    }

    protected Map<String, String> handleRow(ResultSet rs) throws SQLException {
        Map tmpMap = this.usedRowProcessor.toMap(rs);
        CaseInsensitiveMap resMap = new CaseInsensitiveMap();
        for (String currKey : tmpMap.keySet()) {
            resMap.put(currKey, ObjectUtils.toString(tmpMap.get(currKey)));
        }
        return resMap;
    }
}

