/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import de.riwagis.util.StringSupport;
import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.jdbc.DBProduct;
import de.riwagis.util.jdbc.JDBCConnProxy;
import de.riwagis.util.jdbc.JDBCDBMeta;
import de.riwagis.util.jdbc.JDBCDBMetaInterface;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSupport {
    public static final String ELEM_DBMETA = "dbmeta";
    public static final String ELEM_DBPWD = "dbpwd";
    public static final String ELEM_ENCPWD = "encpwd";
    private static final Logger LOG = LoggerFactory.getLogger(JDBCSupport.class);
    private static final Map<String, Integer> mapSqlTypesToInt = Collections.synchronizedMap(new HashMap());
    private static final Map<Integer, String> mapSqlTypesToString = Collections.synchronizedMap(new HashMap());

    public static void setAutoCommit(Connection conn, boolean b) {
        try {
            conn.setAutoCommit(b);
        }
        catch (SQLException e) {
            LOG.warn(String.format("Error setting autocommit to '%s' (Connection: %s)", b, conn), (Throwable)e);
        }
    }

    public static String buildInsertStatement(String tablename, String ... columnNames) {
        if (StringUtils.isBlank((CharSequence)tablename)) {
            throw new IllegalArgumentException("tablename must not be empty");
        }
        if (columnNames.length == 0) {
            throw new IllegalArgumentException("columnNames must not be empty");
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        for (String currColumnName : columnNames) {
            placeholders.add("?");
        }
        String sqlQuery = String.format("INSERT INTO %s (%s) VALUES (%s)", tablename, StringUtils.join((Object[])columnNames, (String)", "), StringUtils.join(placeholders, (String)", "));
        return sqlQuery;
    }

    private JDBCSupport() {
    }

    public static Connection getConnProxy(JDBCDBMetaInterface dbMeta) throws SQLException {
        return new JDBCConnProxy(JDBCSupport.getConn(dbMeta), dbMeta);
    }

    public static Connection getConn(JDBCDBMetaInterface dbMeta, String username, String password) throws SQLException {
        try {
            DbUtils.loadDriver((String)dbMeta.getDBDriver());
            DriverManager.setLoginTimeout(20);
            return DriverManager.getConnection(dbMeta.getDBUrl(), username, password);
        }
        catch (SQLException ex) {
            throw new SQLException(String.format("error connecting '%s'@'%s': %s", username, dbMeta.getDBUrl(), ex.getMessage()), ex.getSQLState(), ex.getErrorCode(), ex);
        }
    }

    public static Connection getConn(JDBCDBMetaInterface dbMeta) throws SQLException {
        return JDBCSupport.getConn(dbMeta, dbMeta.getUsername(), dbMeta.getPassword());
    }

    public static Connection createConnection(Element configElem) throws SystemException, SQLException {
        return JDBCSupport.createConnection(configElem, ELEM_DBMETA);
    }

    public static Connection createConnection(Element configElem, String dbmetaElementName) throws SystemException, SQLException {
        Element dbelem = configElem.getChild(dbmetaElementName);
        if (configElem.getChild(ELEM_ENCPWD) != null) {
            configElem.removeChild(ELEM_ENCPWD);
            String strPWD = dbelem.getChildTextTrim(ELEM_DBPWD);
            byte[] arrKey = Support.getKeyByMacAdress();
            byte[] arrByteEnc = new Base64().decode(strPWD.getBytes());
            strPWD = new String(Support.decrypt(arrByteEnc, arrKey));
            dbelem.getChild(ELEM_DBPWD).setText(strPWD);
        }
        return JDBCSupport.getConnProxy((JDBCDBMetaInterface)JDBCSupport.getDBMetaFromXML(dbelem));
    }

    public static JDBCDBMeta getDBMetaFromXML(Element elem) throws SystemException {
        return JDBCSupport.getDBMetaFromXML(elem, elem.getNamespace());
    }

    public static JDBCDBMeta getDBMetaFromXML(Element elem, Namespace ns) throws SystemException {
        try {
            JDBCDBMeta DBMeta = new JDBCDBMeta();
            DBMeta.setDBDriver(elem.getChildTextTrim("dbdriver", ns));
            DBMeta.setDBUrl(elem.getChildTextTrim("dburl", ns));
            DBMeta.setDBType(ObjectUtils.toString((Object)elem.getChildTextTrim("dbtype", ns)));
            DBMeta.setUsername(elem.getChildTextTrim("dbuser", ns));
            DBMeta.setPassword(elem.getChildTextTrim(ELEM_DBPWD, ns));
            DBMeta.setDBService(elem.getChildTextTrim("dbservice", ns));
            DBMeta.putParameter((Object)"name", (Object)elem.getChildTextTrim("dbname", ns));
            return DBMeta;
        }
        catch (Exception e) {
            throw new SystemException(JDBCSupport.class, (Throwable)e);
        }
    }

    public static boolean isBooleanColumn(int intType) {
        return intType == -7 || intType == 16;
    }

    public static boolean isNumericColumn(int intType) {
        return intType == -5 || intType == 3 || intType == 8 || intType == 6 || intType == 4 || intType == 2 || intType == 7 || intType == 5 || intType == -6;
    }

    public static boolean isNumberDecimalColumn(int intType) {
        return intType == 3 || intType == 8 || intType == 6 || intType == 2 || intType == 7;
    }

    public static boolean isDateColumn(int intType) {
        return intType == 91;
    }

    public static boolean isDateTimeColumn(int intType) {
        return intType == 92 || intType == 93;
    }

    public static boolean isTextColumn(int intType) {
        return intType == 1 || intType == -1 || intType == 12 || intType == -16 || intType == -9 || intType == 2005;
    }

    public static String getSysDateString(Connection conn) throws SystemException {
        try {
            DBProduct strDB = DBProduct.findDBProduct(conn);
            if (strDB != null) {
                return strDB.getSysdateQuery();
            }
            return DBProduct.DBP_UNKNOWN.getSysdateQuery();
        }
        catch (Exception e) {
            throw new SystemException(JDBCSupport.class, (Throwable)e);
        }
    }

    public static String getSqlTypeName(int intType) {
        return mapSqlTypesToString.get(intType);
    }

    public static int getSqlType(String strName) {
        if (mapSqlTypesToInt.containsKey(StringUtils.upperCase((String)strName))) {
            return mapSqlTypesToInt.get(StringUtils.upperCase((String)strName));
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long findMaxValue(Connection conn, String tablename, String colName) throws SQLException {
        Long res = null;
        if (conn == null) throw new NullPointerException(String.format("Connection not defined: %s", conn));
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(String.format("SELECT MAX(%s) AS max_value FROM %s", colName, tablename));){
            if (!rs.next()) return res;
            res = rs.getLong("max_value");
            return res;
        }
    }

    @Deprecated
    public static DBProduct determineDBProduct(Connection conn) {
        return DBProduct.findDBProduct(conn);
    }

    @Deprecated
    public static boolean isConnDBProduct(Connection conn, DBProduct dbProductID) {
        return ObjectUtils.equals((Object)((Object)dbProductID), (Object)((Object)JDBCSupport.determineDBProduct(conn)));
    }

    public static void setAutoCommitQuietly(Connection conn, boolean autoCommit) {
        try {
            if (!conn.isClosed()) {
                conn.setAutoCommit(autoCommit);
            } else {
                LOG.trace("Connection already closed");
            }
        }
        catch (SQLException e) {
            LOG.warn("error setting autocommit transaction", (Throwable)e);
        }
    }

    public static String buildInList(String fieldName, Collection<?> inList) {
        return JDBCSupport.buildInList(fieldName, inList, "");
    }

    public static String buildInList(String fieldName, Collection<?> inList, String quotation) {
        return JDBCSupport.buildInList(fieldName, inList, quotation, 100);
    }

    public static String buildInList(String fieldName, Collection<?> inList, int maxLength) {
        return JDBCSupport.buildInList(fieldName, inList, "", maxLength);
    }

    public static String buildInList(String fieldName, Collection<?> inList, String quotation, int maxLength) {
        ArrayList<String> orParts = new ArrayList<String>();
        if (!inList.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>(maxLength);
            for (Object x : inList) {
                ids.add(StringSupport.quoteString((String)JDBCSupport.escapeSql(ObjectUtils.toString(x)), (String)quotation));
                if (ids.size() < maxLength) continue;
                orParts.add(JDBCSupport.buildInPart(fieldName, ids));
                ids.clear();
            }
            if (!ids.isEmpty()) {
                orParts.add(JDBCSupport.buildInPart(fieldName, ids));
                ids.clear();
            }
        } else {
            orParts.add("1=1");
        }
        return String.format("(%s)", StringUtils.join(orParts, (String)" OR "));
    }

    public static String buildInPart(String fieldName, Collection<String> ids) {
        return ids.size() == 1 ? String.format("%s=%s", fieldName, StringUtils.join(ids, (String)", ")) : String.format("%s IN (%s)", fieldName, StringUtils.join(ids, (String)", "));
    }

    public static PreparedStatement prepareInsertStatement(Connection conn, String tablename, String ... columnNames) throws SQLException {
        String sqlQuery = JDBCSupport.buildInsertStatement(tablename, columnNames);
        return conn.prepareStatement(sqlQuery);
    }

    public static PreparedStatement prepareSelectStatement(Connection conn, String query, Object ... parameters) throws SQLException {
        PreparedStatement stmtQuery = conn.prepareStatement(query);
        try {
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    stmtQuery.setObject(i + 1, parameters[i]);
                }
            }
            return stmtQuery;
        }
        catch (SQLException sqlex) {
            DbUtils.closeQuietly((Statement)stmtQuery);
            throw new SQLException(String.format("Error executing query '%s' (Parameters: [%s]): %s", query, StringUtils.join((Object[])parameters), sqlex.getMessage()), sqlex);
        }
    }

    public static void select2PrepStatementSelect(String strSelect, StringBuilder sbPrepStmtSelect, Collection<String> lstCols) {
        for (int i = 0; i < strSelect.length(); ++i) {
            char chrSource = strSelect.charAt(i);
            if (chrSource == '{') {
                char chrInnerSource;
                if (++i >= strSelect.length()) break;
                StringBuilder sbCol = new StringBuilder();
                while (i < strSelect.length() && (chrInnerSource = strSelect.charAt(i)) != '}') {
                    sbCol.append(chrInnerSource);
                    ++i;
                }
                lstCols.add(sbCol.toString());
                sbPrepStmtSelect.append('?');
                continue;
            }
            chrSource = strSelect.charAt(i);
            sbPrepStmtSelect.append(chrSource);
        }
    }

    public static Object nextIDOracleSequence(Connection conn, String sequenceName) throws SQLException {
        return JDBCSupport.nextID(conn, String.format("SELECT %s.NEXTVAL AS nextid FROM DUAL", sequenceName), sequenceName);
    }

    public static Object nextIDMaxValue(Connection conn, String idFieldName, String tableName) throws SQLException {
        return JDBCSupport.nextID(conn, String.format("SELECT (COALESCE(MAX(%s), 0)+1) AS nextid FROM %s", idFieldName, tableName), String.format("%s.%s", tableName, idFieldName));
    }

    public static Object nextID(Connection conn, String idQuery, String sequenceName) throws SQLException {
        try (PreparedStatement stmtNextID = conn.prepareStatement(idQuery);
             ResultSet rsNextID = stmtNextID.executeQuery();){
            if (rsNextID.next()) {
                Object nextID = rsNextID.getObject(1);
                if (!rsNextID.wasNull()) {
                    Object object = nextID;
                    return object;
                }
            }
            throw new SQLException(String.format("failed to query new id from '%s' on '%s' user '%s'.", sequenceName, conn.getMetaData().getURL(), conn.getMetaData().getUserName()));
        }
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.replace((String)str, (String)"'", (String)"''");
    }

    static {
        for (Field currField : Types.class.getFields()) {
            try {
                mapSqlTypesToInt.put(currField.getName().toUpperCase(), currField.getInt(null));
                mapSqlTypesToString.put(currField.getInt(null), currField.getName().toUpperCase());
            }
            catch (IllegalAccessException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

