/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import de.riwagis.util.jdbc.JDBCSupport;
import de.riwagis.util.jdbc.LabelAwareRowProcessor;
import de.riwagis.util.jdbc.MapListStringHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCDBUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCDBUtils.class);
    private static final Pattern sanitizeRE = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Object[] EMPTY_OBJECTARRAY = new Object[0];
    private static final RowProcessor LABELAWARE_ROWPROCESSOR = new LabelAwareRowProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectQuotationForTableColumn(String strIDCol, String strFrom, Connection conn) throws SQLException {
        String quotation = "";
        PreparedStatement stmt = conn.prepareStatement(String.format("select %s from %s where 1=0", strIDCol, strFrom));
        try {
            ResultSet rs = stmt.executeQuery();
            try {
                ResultSetMetaData rsmetaX = rs.getMetaData();
                int intmeta = rsmetaX.getColumnType(1);
                if (!JDBCSupport.isNumericColumn(intmeta) && !JDBCSupport.isNumberDecimalColumn(intmeta)) {
                    quotation = "'";
                }
            }
            finally {
                DbUtils.closeQuietly((ResultSet)rs);
            }
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
        return quotation;
    }

    public static String firstStringValue(Connection conn, String sqlQuery) throws SQLException {
        return JDBCDBUtils.firstStringValue(conn, sqlQuery, EMPTY_OBJECTARRAY);
    }

    public static String firstStringValue(Connection conn, String sqlQuery, Object ... params) throws SQLException {
        List<String> theStrings = JDBCDBUtils.queryStringsList(conn, sqlQuery, params);
        if (CollectionUtils.isEmpty(theStrings)) {
            return null;
        }
        return theStrings.get(0);
    }

    public static List<String> queryStringsList(Connection conn, String sqlQuery) throws SQLException {
        return JDBCDBUtils.queryStringsList(conn, sqlQuery, EMPTY_OBJECTARRAY);
    }

    public static List<String> queryStringsList(Connection conn, String sqlQuery, Object ... params) throws SQLException {
        return JDBCDBUtils.queryList(conn, String.class, sqlQuery, params);
    }

    public static String lookupValue(Connection conn, String tableName, String valID, String valDefault) throws SQLException {
        return JDBCDBUtils.lookupValue(conn, tableName, "id", "value", valID, valDefault);
    }

    public static String lookupValue(Connection conn, String tableName, String valID) throws SQLException {
        return JDBCDBUtils.lookupValue(conn, tableName, valID, "");
    }

    public static String lookupValue(Connection conn, String tableName, String colID, String colValue, String valID) throws SQLException {
        return JDBCDBUtils.lookupValue(conn, tableName, colID, colValue, valID, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookupValue(Connection conn, String tableName, String columnnameID, String columnnameValue, String valID, String valDefault) throws SQLException {
        String res = valDefault;
        JDBCDBUtils.checkValidSQLPredicate(tableName);
        JDBCDBUtils.checkValidSQLPredicate(columnnameID);
        JDBCDBUtils.checkValidSQLPredicate(columnnameValue);
        String query = String.format("SELECT tbl.%2$s as id, tbl.%3$s as value FROM %1$s tbl WHERE tbl.%2$s=? ORDER BY tbl.%3$s ASC", tableName, columnnameID, columnnameValue);
        try {
            PreparedStatement s = conn.prepareStatement(query);
            s.setString(1, valID);
            try {
                ResultSet rs = s.executeQuery();
                try {
                    if (rs.next()) {
                        res = ObjectUtils.toString((Object)rs.getString("value"));
                    }
                    if (rs.next()) {
                        LOG.info(String.format("lookupValue: Multiple entries in table '%s' for '%s'='%s' found.", tableName, columnnameID, valID));
                    }
                }
                finally {
                    DbUtils.closeQuietly((ResultSet)rs);
                }
            }
            finally {
                DbUtils.closeQuietly((Statement)s);
            }
            return res;
        }
        catch (SQLException sqlex) {
            throw new SQLException(String.format("Unable to execute query '%s' on connection '%s': %s", query, conn.getMetaData().getURL(), sqlex.getMessage()), sqlex);
        }
    }

    public static final boolean isValidSQLPredicate(String sqlPredicate) {
        return sanitizeRE.matcher(sqlPredicate).matches();
    }

    public static final void checkValidSQLPredicate(String sqlPredicate) {
        if (!JDBCDBUtils.isValidSQLPredicate(sqlPredicate)) {
            throw new IllegalArgumentException(String.format("Illegal SQL predicate: '%s'", sqlPredicate));
        }
    }

    public static List<Object[]> selectDataFromDBAsArray(Connection conn, String strSQL, Object ... params) throws SQLException {
        QueryRunner run = new QueryRunner(true);
        ArrayListHandler rsHandler = new ArrayListHandler();
        return (List)run.query(conn, strSQL, (ResultSetHandler)rsHandler, params);
    }

    public static List<Map<String, Object>> selectDataFromDBAsMap(Connection conn, String strSQL) throws SQLException {
        return JDBCDBUtils.selectDataFromDBAsMap(conn, strSQL, new Object[0]);
    }

    public static List<Map<String, Object>> selectDataFromDBAsMap(Connection conn, String strSQL, Object ... params) throws SQLException {
        MapListHandler rsHandler = new MapListHandler(LABELAWARE_ROWPROCESSOR);
        return JDBCDBUtils.selectDataFromDBAsMap(conn, strSQL, (ResultSetHandler<List<Map<String, Object>>>)rsHandler, params);
    }

    public static List<Map<String, Object>> selectDataFromDBAsMap(Connection conn, String strSQL, ResultSetHandler<List<Map<String, Object>>> rsHandler, Object ... params) throws SQLException {
        QueryRunner run = new QueryRunner(true);
        return (List)run.query(conn, strSQL, rsHandler, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadSelectList(Connection conn, String sql, Map<String, String> idValueMap) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            ResultSet rs = stmt.executeQuery();
            try {
                while (rs.next()) {
                    idValueMap.put(rs.getString(1), rs.getString(2));
                }
            }
            finally {
                DbUtils.closeQuietly((ResultSet)rs);
            }
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    public static final Map<String, String> loadSelectList(Connection conn, String sql) throws SQLException {
        LinkedHashMap<String, String> idValueMap = new LinkedHashMap<String, String>();
        JDBCDBUtils.loadSelectList(conn, sql, idValueMap);
        return idValueMap;
    }

    public static <M> List<M> queryList(Connection conn, Class<M> aClass, String sqlQuery) throws SQLException {
        return JDBCDBUtils.queryList(conn, aClass, sqlQuery, EMPTY_OBJECTARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <M> List<M> queryList(Connection conn, Class<M> aClass, String sqlQuery, Object ... params) throws SQLException {
        ArrayList<Object> res = new ArrayList<Object>();
        PreparedStatement stmt = conn.prepareStatement(sqlQuery);
        try {
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            ResultSet rs = stmt.executeQuery();
            try {
                while (rs.next()) {
                    if (aClass.isAssignableFrom(String.class)) {
                        res.add(rs.getString(1));
                        continue;
                    }
                    if (aClass.isAssignableFrom(Integer.class)) {
                        res.add(rs.getInt(1));
                        continue;
                    }
                    if (aClass.isAssignableFrom(Double.class)) {
                        res.add(rs.getDouble(1));
                        continue;
                    }
                    if (aClass.isAssignableFrom(Float.class)) {
                        res.add(Double.valueOf(rs.getFloat(1)));
                        continue;
                    }
                    res.add(rs.getObject(1));
                }
            }
            finally {
                DbUtils.closeQuietly((ResultSet)rs);
            }
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
        return res;
    }

    public static List<Map<String, String>> selectStringFromDBAsMap(Connection _conn, String _sqlQuery, Object ... _params) throws SQLException {
        QueryRunner run = new QueryRunner(true);
        MapListStringHandler rsHandler = new MapListStringHandler(LABELAWARE_ROWPROCESSOR);
        List res = (List)run.query(_conn, _sqlQuery, (ResultSetHandler)rsHandler, _params);
        return res;
    }

    public static final int executeUpdate(Connection _conn, String _updateQuery, Object ... parameters) throws SQLException {
        PreparedStatement stmtUpdateQuery = _conn.prepareStatement(_updateQuery);
        try {
            int i;
            if (parameters != null) {
                for (i = 0; i < parameters.length; ++i) {
                    stmtUpdateQuery.setObject(i + 1, parameters[i]);
                }
            }
            i = stmtUpdateQuery.executeUpdate();
            return i;
        }
        catch (SQLException sqlex) {
            throw new SQLException(String.format("Error executing '%s' (Parameters: [%s]): %s", _updateQuery, StringUtils.join((Object[])parameters), sqlex.getMessage()), sqlex);
        }
        finally {
            DbUtils.closeQuietly((Statement)stmtUpdateQuery);
        }
    }

    public static final void closeConnections(Collection<Connection> _connections) throws SQLException {
        for (Connection currConnection : _connections) {
            LOG.debug(String.format("Closing connection: '%s'", currConnection));
            DbUtils.close((Connection)currConnection);
        }
    }

    public static final void closeConnectionsQuietly(Collection<Connection> _connections) {
        for (Connection currConnection : _connections) {
            LOG.debug(String.format("Closing connection: '%s'", currConnection));
            DbUtils.closeQuietly((Connection)currConnection);
        }
    }

    private JDBCDBUtils() {
    }
}

