/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import de.riwagis.util.jdbc.JDBCDBMeta;
import de.riwagis.util.jdbc.JDBCDBMetaInterface;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.dbutils.DbUtils;

public class JDBCConnProxy
implements Connection {
    private final Connection conn;
    private final JDBCDBMetaInterface DBMeta;
    private final long lngTime;

    public JDBCConnProxy(Connection _conn, JDBCDBMetaInterface _DBMeta, boolean _readonly) throws SQLException {
        this.conn = _conn;
        this.DBMeta = _DBMeta;
        this.lngTime = new Date().getTime();
        this.conn.setReadOnly(_readonly);
    }

    public JDBCConnProxy(Connection _conn, JDBCDBMetaInterface _DBMeta) throws SQLException {
        this(_conn, _DBMeta, false);
    }

    public JDBCConnProxy(Connection _conn, JDBCDBMeta _DBMeta) throws SQLException {
        this(_conn, (JDBCDBMetaInterface)_DBMeta, _DBMeta.getReadonly());
    }

    public boolean selfCheck() {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
        return false;
    }

    public String getName() {
        return this.DBMeta.toString();
    }

    public JDBCDBMetaInterface getJDBCDBMeta() {
        return this.DBMeta;
    }

    public String getUsername() {
        return this.DBMeta.getUsername();
    }

    public String getPWD() {
        return this.DBMeta.getPassword();
    }

    public long getTime() {
        return this.lngTime;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.conn.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.conn.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.conn.prepareStatement(sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    @Override
    public Struct createStruct(String typeName, Object[] arrObj) throws SQLException {
        return this.conn.createStruct(typeName, arrObj);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] arrObj) throws SQLException {
        return this.conn.createArrayOf(typeName, arrObj);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties prop) throws SQLClientInfoException {
        this.conn.setClientInfo(prop);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn.getClientInfo(name);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.conn.setClientInfo(name, value);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn.isValid(timeout);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.conn.isWrapperFor(clazz);
    }

    public Object unwrap(Class clazz) throws SQLException {
        return this.conn.unwrap(clazz);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.conn.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.conn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.conn.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.conn.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.conn.getNetworkTimeout();
    }
}

