/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DBProduct {
    DBP_POSTGRES("POSTGRESQL", "CURRENT_TIMESTAMP"),
    DBP_MYSQL("MYSQL", "SYSDATE()"),
    DBP_MARIADB("MARIADB", "SYSDATE()"),
    DBP_ORACLE("ORACLE", "sysdate"),
    DBP_UNKNOWN("UNKNOWN", "sysdate"),
    DBP_HSQLDB("HSQL Database Engine", ".*HSQL.*", "sysdate"),
    DBP_MSSQLSERVER("Microsoft SQL Server", "Microsoft ?SQL ?Server|sqlserver", "SYSDATETIME()");

    private static final Logger LOG;
    private final String identification;
    private final String sysdateQuery;
    private final Pattern pattern;

    public static final boolean isConnDBProduct(Connection conn, DBProduct dbProductID) {
        return ObjectUtils.equals((Object)((Object)dbProductID), (Object)((Object)DBProduct.findDBProduct(conn)));
    }

    public static final DBProduct findDBProduct(Connection _databaseConnection) {
        try {
            return DBProduct.findDBProduct(_databaseConnection.getMetaData().getDatabaseProductName());
        }
        catch (SQLException sqlex) {
            LOG.warn("DB-Metadata unavailable", (Throwable)sqlex);
            return null;
        }
    }

    public static final DBProduct findDBProduct(String databaseProductName) {
        DBProduct res = DBP_UNKNOWN;
        for (DBProduct currDBProduct : DBProduct.values()) {
            if (!currDBProduct.getPattern().matcher(databaseProductName).matches()) continue;
            res = currDBProduct;
        }
        return res;
    }

    private DBProduct(String _identification, String _pattern, String _sysdateQuery) {
        this.pattern = Pattern.compile((String)StringUtils.defaultIfEmpty((CharSequence)_pattern, (CharSequence)_identification), 2);
        this.identification = _identification;
        this.sysdateQuery = _sysdateQuery;
    }

    private DBProduct(String _identification, String _sysdateQuery) {
        this(_identification, _identification, _sysdateQuery);
    }

    public String getIdentification() {
        return this.identification;
    }

    public String getSysdateQuery() {
        return this.sysdateQuery;
    }

    protected final Pattern getPattern() {
        return this.pattern;
    }

    static {
        LOG = LoggerFactory.getLogger(DBProduct.class);
    }
}

