/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectoryBase;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.image.ImageRotation;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ImageSupport.class);

    public static boolean adobeReaderBugFix(BufferedImage bim) {
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        for (int w = 0; w < bim.getWidth(); ++w) {
            for (int h = 0; h < bim.getHeight(); ++h) {
                int currentColor = bim.getRGB(w, h);
                bbuf.clear();
                bbuf.putInt(currentColor);
                byte[] arrColor = bbuf.array();
                if (arrColor[0] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void adobeReaderBugFix2(BufferedImage bim) {
        byte[] arrColor;
        int currentColor;
        int h;
        int w;
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        for (w = 0; w < bim.getWidth(); ++w) {
            for (h = 0; h < bim.getHeight(); ++h) {
                currentColor = bim.getRGB(w, h);
                bbuf.clear();
                bbuf.putInt(currentColor);
                arrColor = bbuf.array();
                if (arrColor[0] == 0 || (arrColor[0] == -1 || arrColor[0] == 255) && arrColor[1] == 0 && arrColor[2] == 0 && arrColor[3] == 0) continue;
                return;
            }
        }
        for (w = 0; w < bim.getWidth(); ++w) {
            for (h = 0; h < bim.getHeight(); ++h) {
                currentColor = bim.getRGB(w, h);
                bbuf.clear();
                bbuf.putInt(currentColor);
                arrColor = bbuf.array();
                if (arrColor[0] != -1 && arrColor[0] != 255) continue;
                arrColor[0] = -2;
                arrColor[1] = 0;
                arrColor[2] = 0;
                arrColor[3] = 0;
                bbuf.clear();
                bbuf.put(arrColor);
                bbuf.flip();
                int newColor = bbuf.getInt();
                bim.setRGB(w, h, newColor);
            }
        }
    }

    public static BufferedImage readImage(File imageFile) throws IOException {
        return ImageIO.read(imageFile);
    }

    public static BufferedImage resizeImage(BufferedImage imageSrc, int maxPixelsInXorY) {
        return ImageSupport.resizeImage(imageSrc, maxPixelsInXorY, ImageRotation.NONE);
    }

    public static BufferedImage resizeImage(BufferedImage imageSrc, int maxPixelsInXorY, ImageRotation rotation) {
        AffineTransform transformation = new AffineTransform();
        transformation.concatenate(rotation.getTransformation());
        float maxPixels = Math.max(imageSrc.getWidth(), imageSrc.getHeight());
        float scale = (float)maxPixelsInXorY / maxPixels;
        transformation.concatenate(AffineTransform.getScaleInstance(scale, scale));
        Point sourcePos = new Point(0, 0);
        Point sourceSize = new Point(imageSrc.getWidth(), imageSrc.getHeight());
        Point targetPos = new Point(sourcePos);
        Point targetSize = new Point(sourceSize);
        transformation.transform(sourceSize, targetSize);
        transformation.transform(sourcePos, targetPos);
        int xMin = Math.min(targetPos.x, targetSize.x);
        int xMax = Math.max(targetPos.x, targetSize.x);
        int yMin = Math.min(targetPos.y, targetSize.y);
        int yMax = Math.max(targetPos.y, targetSize.y);
        AffineTransform scaleInstance = AffineTransform.getTranslateInstance(-xMin, -yMin);
        scaleInstance.concatenate(transformation);
        transformation = scaleInstance;
        int scaledWidth = xMax - xMin;
        int scaledHeight = yMax - yMin;
        BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, imageSrc.getType());
        AffineTransformOp affineTransformOp = new AffineTransformOp(transformation, 3);
        affineTransformOp.filter(imageSrc, scaledImage);
        return scaledImage;
    }

    public static void writeImage(RenderedImage imageSrc, File imgFileDst, String imgFormat) throws SystemException {
        block13: {
            try {
                Iterator<ImageWriter> itWr;
                if (imgFormat.equalsIgnoreCase("tif")) {
                    imgFormat = "TIFF";
                }
                if (imgFormat.equalsIgnoreCase("jpg")) {
                    imgFormat = "JPEG";
                }
                if ((itWr = ImageIO.getImageWritersByFormatName(imgFormat)).hasNext()) {
                    try (ImageOutputStream iout = ImageIO.createImageOutputStream(imgFileDst);){
                        ImageWriter wr = itWr.next();
                        wr.setOutput(iout);
                        final AtomicBoolean outputReady = new AtomicBoolean(false);
                        IIOWriteProgressListener pl = new IIOWriteProgressListener(){

                            @Override
                            public void imageStarted(ImageWriter source, int imageIndex) {
                            }

                            @Override
                            public void imageProgress(ImageWriter source, float percentageDone) {
                            }

                            @Override
                            public void imageComplete(ImageWriter source) {
                                outputReady.set(true);
                            }

                            @Override
                            public void thumbnailStarted(ImageWriter source, int imageIndex, int thumbnailIndex) {
                            }

                            @Override
                            public void thumbnailProgress(ImageWriter source, float percentageDone) {
                            }

                            @Override
                            public void thumbnailComplete(ImageWriter source) {
                            }

                            @Override
                            public void writeAborted(ImageWriter source) {
                                outputReady.set(true);
                            }
                        };
                        wr.addIIOWriteProgressListener(pl);
                        wr.write(imageSrc);
                        while (!outputReady.get()) {
                            Thread.sleep(50L);
                        }
                        break block13;
                    }
                }
                throw new IOException("Unknown image format: " + imgFormat);
            }
            catch (IOException | InterruptedException e) {
                if (e instanceof SystemException) {
                    throw (SystemException)e;
                }
                throw new SystemException((Throwable)e);
            }
        }
    }

    public static void resizeImage(File imgFileSrc, File imgFileDst, int maxPixelsInXorY, String outFormat) throws SystemException {
        ImageSupport.resizeImage(imgFileSrc, imgFileDst, maxPixelsInXorY, outFormat, ImageRotation.NONE);
    }

    public static void resizeImage(File imgFileSrc, File imgFileDst, int maxPixelsInXorY, String outFormat, ImageRotation rotation) throws SystemException {
        try {
            BufferedImage i = ImageSupport.readImage(imgFileSrc);
            BufferedImage o = ImageSupport.resizeImage(i, maxPixelsInXorY, rotation);
            ImageSupport.writeImage(o, imgFileDst, outFormat);
        }
        catch (SystemException | IOException e) {
            throw new SystemException(e);
        }
    }

    public static final ImageRotation detectOrientation(File imageFile) {
        ImageRotation ir = ImageRotation.NONE;
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)imageFile);
            for (ExifDirectoryBase currExifDirectory : metadata.getDirectoriesOfType(ExifDirectoryBase.class)) {
                Integer orient;
                if (currExifDirectory == null || (orient = currExifDirectory.getInteger(274)) == null) continue;
                ir = ImageRotation.byExifOrientationTag(orient);
            }
        }
        catch (ImageProcessingException | IOException ex) {
            LOG.warn(String.format("unable to aquire metadata from '%s': %s", imageFile.getAbsolutePath(), ex.getMessage()), ex);
        }
        return ir;
    }

    public static boolean compareImage(RenderedImage biA, RenderedImage biB) {
        DataBuffer dbB;
        int sizeB;
        DataBuffer dbA = biA.getData().getDataBuffer();
        int sizeA = dbA.getSize();
        if (sizeA == (sizeB = (dbB = biB.getData().getDataBuffer()).getSize())) {
            for (int i = 0; i < sizeA; ++i) {
                if (dbA.getElem(i) == dbB.getElem(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ImageSupport() {
    }
}

