/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.image;

import java.awt.geom.AffineTransform;
import java.util.LinkedHashMap;
import java.util.Map;

public enum ImageRotation {
    FLIP_HORI(AffineTransform.getScaleInstance(-1.0, 1.0)),
    FLIP_VERT(AffineTransform.getScaleInstance(1.0, -1.0)),
    FLIP_DIAG(ImageRotation.rotateAndFlipHorizontally(1)),
    FLIP_ANTIDIAG(ImageRotation.rotateAndFlipHorizontally(-1)),
    CW_90DEG(AffineTransform.getQuadrantRotateInstance(1)),
    CW_180DEG(AffineTransform.getQuadrantRotateInstance(2)),
    CW_270DEG(AffineTransform.getQuadrantRotateInstance(3)),
    CCW_90DEG(AffineTransform.getQuadrantRotateInstance(-1)),
    CCW_180DEG(AffineTransform.getQuadrantRotateInstance(-2)),
    CCW_270DEG(AffineTransform.getQuadrantRotateInstance(-3)),
    CCW_0DEG(new AffineTransform()),
    CW_0DEG(new AffineTransform()),
    NONE(new AffineTransform());

    private static final Map<Integer, ImageRotation> EXIF_ORIENTATION_LOOKUP;
    private final AffineTransform transformation;

    private static Map<Integer, ImageRotation> createExifOrientationLookup() {
        LinkedHashMap<Integer, ImageRotation> res = new LinkedHashMap<Integer, ImageRotation>();
        res.put(1, NONE);
        res.put(2, FLIP_HORI);
        res.put(3, CW_180DEG);
        res.put(4, FLIP_VERT);
        res.put(5, FLIP_DIAG);
        res.put(6, CW_90DEG);
        res.put(7, FLIP_ANTIDIAG);
        res.put(8, CW_270DEG);
        return res;
    }

    private ImageRotation(AffineTransform transformation) {
        this.transformation = transformation;
    }

    public boolean needsTransformation() {
        return !this.transformation.isIdentity();
    }

    public AffineTransform getTransformation() {
        return this.transformation;
    }

    public static final ImageRotation byExifOrientationTag(int exifOrientation) {
        ImageRotation orientation = EXIF_ORIENTATION_LOOKUP.get(exifOrientation);
        return orientation != null ? orientation : NONE;
    }

    private static AffineTransform rotateAndFlipHorizontally(int quadrants) {
        AffineTransform transform = AffineTransform.getQuadrantRotateInstance(quadrants);
        transform.scale(1.0, -1.0);
        return transform;
    }

    static {
        EXIF_ORIENTATION_LOOKUP = ImageRotation.createExifOrientationLookup();
    }
}

