/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.exception;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionSupport {
    public static <T extends Throwable> T findFirst(Throwable t, Class<T> aClass) {
        for (Throwable currThrowable : ExceptionUtils.getThrowables((Throwable)t)) {
            if (!aClass.isInstance(currThrowable)) continue;
            return (T)currThrowable;
        }
        return null;
    }

    public static String formatHTMLMessage(String s) {
        if (s != null) {
            return s.replaceAll("(\r\n|\n\r|\r|\n)", "<br>");
        }
        return s;
    }

    public static String getHTMLMessage(Throwable t) {
        return t != null ? ExceptionSupport.formatHTMLMessage(t.getMessage()) : "null";
    }

    public static String formatJSMessage(String s) {
        Object strReturn = ObjectUtils.toString((Object)s);
        strReturn = ((String)strReturn).replaceAll("(\r\n|\n\r|\r|\n)", " ");
        strReturn = ((String)strReturn).replaceAll("\\\"", "'");
        strReturn = "alert(\"" + (String)strReturn + "\");\n";
        return strReturn;
    }

    public static String addScriptTag(String s) {
        return String.format("<script type='text/javascript'>\n%s</script>\n", s);
    }

    public static String getJSMessage(Throwable t, boolean bolScriptTag) {
        String strReturn = t == null ? "null" : t.getMessage();
        strReturn = ExceptionSupport.formatJSMessage(strReturn);
        if (bolScriptTag) {
            return ExceptionSupport.addScriptTag(strReturn);
        }
        return strReturn;
    }
}

