/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.excel;

import de.riwagis.util.Config;
import de.riwagis.util.excel.XlsCelltype;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class XlsExportSupport {
    public static final char DECIMAL_SEPARATOR = new DecimalFormatSymbols(Config.LOCALE).getDecimalSeparator();
    public static final char GROUPING_SEPARATOR = new DecimalFormatSymbols(Config.LOCALE).getGroupingSeparator();
    private static final Pattern XLSNUMERICMATCH = Pattern.compile(String.format("^([-+])?((?:[0-9]+(?:%s)?)*(?:[0-9]*))(%s)?([0-9]+)?([e][+-]?[0-9]+)?$", Pattern.quote("" + GROUPING_SEPARATOR), Pattern.quote("" + DECIMAL_SEPARATOR)));
    private static final Pattern HTML = Pattern.compile("<[bB][rR][ ]*/?>");
    private static final Pattern NEWLINE = Pattern.compile("\\&nbsp;");
    private static final Pattern DATE = Pattern.compile("(0?[0-9]|[12][0-9]|3[01])\\s*\\.(0?[0-9]|1[012])\\s*\\.([0-9]{1,4})\\s*");

    public static final boolean isXlsDate(String strCandidate) {
        return StringUtils.isNotBlank((CharSequence)strCandidate) && DATE.matcher(strCandidate).matches();
    }

    public static final boolean isXlsNumeric(String strCandidate) {
        if (StringUtils.isBlank((CharSequence)strCandidate)) {
            return true;
        }
        String trimmedCandidate = StringUtils.trimToEmpty((String)strCandidate);
        return XLSNUMERICMATCH.matcher(trimmedCandidate).matches();
    }

    public static String removeHtml(String sourceString) {
        if (StringUtils.isNotBlank((CharSequence)sourceString)) {
            return NEWLINE.matcher(HTML.matcher(sourceString).replaceAll("\n")).replaceAll(" ");
        }
        return sourceString;
    }

    public static final void removeHtml(String[][] arrData, boolean bolFirstLineIsHeader) {
        int intStart = bolFirstLineIsHeader ? 1 : 0;
        for (String[] columnData : arrData) {
            for (int j = intStart; j < columnData.length; ++j) {
                columnData[j] = XlsExportSupport.removeHtml(columnData[j]);
            }
        }
    }

    public static final XlsCelltype[] getTypes(String[][] arrData, boolean bolFirstLineIsHeader) {
        XlsCelltype[] arrTypes = new XlsCelltype[arrData.length];
        int intStart = bolFirstLineIsHeader ? 1 : 0;
        for (int i = 0; i < arrData.length; ++i) {
            arrTypes[i] = XlsExportSupport.getColumnType(intStart, arrData[i]);
        }
        return arrTypes;
    }

    public static final void exportStringArray2Excel(String[][] cellData, File targetFile, boolean hasHeaderLine) throws IOException, ParseException {
        boolean useExcelXmlFormat = !FilenameUtils.isExtension((String)targetFile.getAbsolutePath(), (String)"xls");
        try (Workbook workbook = XlsExportSupport.createWorkbook(useExcelXmlFormat);){
            int intStart;
            Sheet sheet = workbook.createSheet("export");
            NumberFormat nf = NumberFormat.getNumberInstance(Config.LOCALE);
            nf.setGroupingUsed(false);
            XlsExportSupport.removeHtml(cellData, false);
            XlsCelltype[] arrTypes = XlsExportSupport.getTypes(cellData, hasHeaderLine);
            if (hasHeaderLine) {
                Row headerRow = sheet.createRow(0);
                for (int i = 0; i < cellData.length; ++i) {
                    headerRow.createCell(i).setCellValue(XlsExportSupport.replaceNewlines(cellData[i][0]));
                }
            }
            for (int row = intStart = hasHeaderLine ? 1 : 0; row < cellData[0].length; ++row) {
                Row dataRow = sheet.createRow(row);
                for (int column = 0; column < cellData.length; ++column) {
                    XlsExportSupport.fillRow(cellData[column][row], dataRow, nf, arrTypes[column], column);
                }
            }
            XlsExportSupport.writeWorkbookToFile(workbook, targetFile);
            if (useExcelXmlFormat) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
    }

    public static void writeWorkbookToFile(Workbook workbook, File targetFile) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
            workbook.write((OutputStream)fileOutputStream);
        }
    }

    private static Workbook createWorkbook(boolean useExcelXmlFormat) {
        if (useExcelXmlFormat) {
            SXSSFWorkbook streamingXLSX = new SXSSFWorkbook();
            streamingXLSX.setCompressTempFiles(true);
            return streamingXLSX;
        }
        return new HSSFWorkbook();
    }

    private static void fillRow(String s, Row dataRow, NumberFormat nf, XlsCelltype arrType, int column) throws ParseException {
        if (arrType == XlsCelltype.NUMERIC) {
            Cell cell = dataRow.createCell(column, CellType.NUMERIC);
            if (s != null && !s.isEmpty()) {
                String strExp = s.replace("" + GROUPING_SEPARATOR, "");
                double dblNum = nf.parse(strExp.trim()).doubleValue();
                cell.setCellValue(dblNum);
            }
        } else {
            String text = XlsExportSupport.replaceNewlines(Objects.toString(s, ""));
            dataRow.createCell(column, CellType.STRING).setCellValue(text);
        }
    }

    private static String replaceNewlines(String text) {
        return text.replace("\\r\\n", System.lineSeparator());
    }

    public static XlsCelltype getColumnType(int intStart, String[] columnData) {
        for (int j = intStart; j < columnData.length; ++j) {
            String currData = columnData[j];
            if (!XlsExportSupport.isXlsDate(currData) && XlsExportSupport.isXlsNumeric(currData)) continue;
            return XlsCelltype.TEXT;
        }
        return XlsCelltype.NUMERIC;
    }

    private XlsExportSupport() {
    }
}

