/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GroupingTree<K, V> {
    private final K key;
    private final Map<K, GroupingTree<K, V>> subtrees = new LinkedHashMap<K, GroupingTree<K, V>>();
    private final List<V> entries = new LinkedList<V>();

    protected GroupingTree(K key) {
        this.key = key;
    }

    public GroupingTree() {
        this(null);
    }

    public void put(List<K> keyList, V item) {
        K childKey;
        this.entries.add(item);
        if (keyList != null && keyList.size() > 0 && (childKey = keyList.get(0)) != null) {
            GroupingTree<K, V> childTree = this.subtrees.get(childKey);
            if (childTree == null) {
                childTree = new GroupingTree<K, V>(childKey);
                this.subtrees.put(childKey, childTree);
            }
            childTree.put(keyList.subList(1, keyList.size()), item);
        }
    }

    public List<V> get(List<K> keyList) {
        GroupingTree<K, V> currTree = this;
        if (keyList != null) {
            for (K currKey : keyList) {
                currTree = currTree.subtrees.get(currKey);
            }
        }
        return currTree.entries;
    }

    public void put(K[] keys, V item) {
        this.put(Arrays.asList(keys), item);
    }

    public List<V> get(K[] keys) {
        return this.get(Arrays.asList(keys));
    }

    private static <K, V> void fillGroupList(List<List<K>> groupList, GroupingTree<K, V> currTree, List<K> keysSoFar, int reqDepth) {
        if (groupList != null) {
            if (keysSoFar.size() == reqDepth) {
                groupList.add(keysSoFar);
            }
            if (keysSoFar.size() < reqDepth) {
                for (GroupingTree<K, V> nextTree : currTree.subtrees.values()) {
                    LinkedList<K> newKeys = new LinkedList<K>();
                    newKeys.addAll(keysSoFar);
                    newKeys.add(nextTree.key);
                    GroupingTree.fillGroupList(groupList, nextTree, newKeys, reqDepth);
                }
            }
        }
    }

    public List<List<K>> getGroups(int depth) {
        LinkedList<List<K>> res = new LinkedList<List<K>>();
        GroupingTree.fillGroupList(res, this, new ArrayList(), depth);
        return res;
    }

    public static <K, V> void fillGroupEntries(Map<List<K>, List<V>> entries, GroupingTree<K, V> currTree, List<K> keysSoFar, int reqDepth) {
        if (entries != null) {
            if (keysSoFar.size() == reqDepth) {
                entries.put(keysSoFar, currTree.entries);
            }
            if (keysSoFar.size() < reqDepth) {
                for (GroupingTree<K, V> nextTree : currTree.subtrees.values()) {
                    LinkedList<K> newKeys = new LinkedList<K>();
                    newKeys.addAll(keysSoFar);
                    newKeys.add(nextTree.key);
                    GroupingTree.fillGroupEntries(entries, nextTree, newKeys, reqDepth);
                }
            }
        }
    }

    public static <K, V> String printTree(GroupingTree<K, V> tree, String indent) {
        Object res = "";
        res = (String)res + indent + tree.key + " (Entries:" + tree.entries.size() + ", Subtrees: " + tree.subtrees.size() + ") ";
        if (tree.subtrees.size() > 0) {
            res = (String)res + "[\n";
            for (GroupingTree<K, V> x : tree.subtrees.values()) {
                res = (String)res + GroupingTree.printTree(x, indent + "  ") + "\n";
            }
            res = (String)res + indent + "]";
        }
        return res;
    }

    public String toString() {
        return GroupingTree.printTree(this, "");
    }
}

