/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.adresszuweiser;

import de.riwagis.util.StringSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class AdressZuweiserInput {
    private static final Logger LOG = LoggerFactory.getLogger(AdressZuweiserInput.class);
    private String street;
    private String streetnumber;
    private String streetnumberSuffix;
    private String zipCode;
    private String city;
    private final Map<String, String> optional = new LinkedHashMap<String, String>();

    public AdressZuweiserInput(String strasse, String plz, String ort) {
        this.setCompleteStreet(strasse);
        this.setZipCode(plz);
        this.setCity(ort);
    }

    public AdressZuweiserInput(String street, String streetnumber, String streetnumberSuffix, String zipCode, String city) {
        if (StringUtils.isBlank((CharSequence)streetnumber) || !StringUtils.isNumeric((CharSequence)streetnumber)) {
            this.setCompleteStreet(String.format("%s %s %s", street, streetnumber, streetnumberSuffix));
        } else {
            this.setStreet(street);
            this.setStreetnumber(streetnumber);
            this.setStreetnumberSuffix(streetnumberSuffix);
        }
        this.setZipCode(zipCode);
        this.setCity(city);
    }

    public void setCompleteStreet(String strStrasse) {
        String strStr = "";
        String strHnr = "";
        String strHnrZus = "";
        Pattern p = Pattern.compile("[\\s]*([^\\d]+)?[\\s]*([\\d]+)?([,+ ][\\d]*)?[\\s]*(.+)?[\\s]*");
        Matcher match = p.matcher(strStrasse.toLowerCase());
        if (match.matches()) {
            strStr = StringUtils.defaultString((String)match.group(1)).trim().toLowerCase();
            strHnr = StringUtils.defaultString((String)match.group(2)).trim().toLowerCase();
            strHnrZus = StringUtils.defaultString((String)match.group(4)).trim().toLowerCase();
        }
        strStr = StringUtils.normalizeSpace((String)strStr.replaceAll("\\.([^-])", ". $1"));
        strStr = StringSupport.replace((String)strStr, (String)"str.", (String)"stra\u00dfe", (boolean)true);
        if ((strStr = StringSupport.replace((String)strStr, (String)"strasse", (String)"stra\u00dfe", (boolean)true)).endsWith("str")) {
            strStr = StringSupport.replace((String)strStr, (String)"str", (String)"stra\u00dfe", (boolean)true);
        }
        this.setStreet(strStr);
        this.setStreetnumber(strHnr);
        this.setStreetnumberSuffix(strHnrZus);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetnumber() {
        return this.streetnumber;
    }

    public void setStreetnumber(String streetnumber) {
        this.streetnumber = streetnumber;
    }

    public String getStreetnumberSuffix() {
        return this.streetnumberSuffix;
    }

    public void setStreetnumberSuffix(String streetnumberSuffix) {
        this.streetnumberSuffix = streetnumberSuffix;
    }

    public void setOptionalValue(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            this.optional.put(key, value);
        }
    }

    public String getOptionalValue(String key) {
        return this.optional.get(key);
    }

    public String toString() {
        return String.format("%s %s%s, %s %s", this.street, this.streetnumber, this.streetnumberSuffix, this.zipCode, this.city);
    }

    public boolean hasMinimumFieldsSet() {
        return StringUtils.isNotBlank((CharSequence)this.street) && StringUtils.isNotBlank((CharSequence)this.streetnumber) && (StringUtils.isNotBlank((CharSequence)this.zipCode) || StringUtils.isNotBlank((CharSequence)this.city));
    }
}

