/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.adresszuweiser;

import de.riwagis.util.StringSupport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AdressZuweiserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AdressZuweiserHelper.class);

    public static final Collection<String> removeSpaces(Collection<String> alternatives) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (String currAlternative : alternatives) {
            res.add(StringUtils.replace((String)currAlternative, (String)" ", (String)""));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, Collection<String>> loadOrtToStrassenMap(Connection conn) throws SQLException {
        LinkedHashMap<String, Collection<String>> ortToStrassen = new LinkedHashMap<String, Collection<String>>();
        PreparedStatement pstmtOrtToStrassen = conn.prepareStatement("SELECT DISTINCT ort, strasse FROM hn_adresse");
        try {
            ResultSet rsOrtToStrassen = pstmtOrtToStrassen.executeQuery();
            try {
                while (rsOrtToStrassen.next()) {
                    Collection<String> currStrassenInOrt;
                    String currOrt = rsOrtToStrassen.getString("ort");
                    if (!ortToStrassen.containsKey(currOrt)) {
                        currStrassenInOrt = new LinkedHashSet();
                        ortToStrassen.put(currOrt, currStrassenInOrt);
                    } else {
                        currStrassenInOrt = (Collection)ortToStrassen.get(currOrt);
                    }
                    currStrassenInOrt.add(rsOrtToStrassen.getString("strasse"));
                }
            }
            finally {
                DbUtils.closeQuietly((ResultSet)rsOrtToStrassen);
            }
        }
        finally {
            DbUtils.closeQuietly((Statement)pstmtOrtToStrassen);
        }
        PreparedStatement pstmtPLZToStrassen = conn.prepareStatement("SELECT DISTINCT plz, strasse FROM hn_adresse");
        try {
            ResultSet rsPLZToStrassen = pstmtPLZToStrassen.executeQuery();
            try {
                while (rsPLZToStrassen.next()) {
                    Collection<String> currStrassenInPLZ;
                    String currPLZ = rsPLZToStrassen.getString("plz");
                    if (!ortToStrassen.containsKey(currPLZ)) {
                        currStrassenInPLZ = new LinkedHashSet();
                        ortToStrassen.put(currPLZ, currStrassenInPLZ);
                    } else {
                        currStrassenInPLZ = (Collection)ortToStrassen.get(currPLZ);
                    }
                    currStrassenInPLZ.add(rsPLZToStrassen.getString("strasse"));
                }
            }
            finally {
                DbUtils.closeQuietly((ResultSet)rsPLZToStrassen);
            }
        }
        finally {
            DbUtils.closeQuietly((Statement)pstmtPLZToStrassen);
        }
        return ortToStrassen;
    }

    public static final String findByMinLevenshteinDistance(Collection<String> knownOrte, Collection<String> ortAlternatives) {
        int oldDistance = Integer.MAX_VALUE;
        String foundOrt = null;
        for (String currOrt : knownOrte) {
            for (String currSearchOrt : ortAlternatives) {
                int currDistance = StringUtils.getLevenshteinDistance((CharSequence)currOrt, (CharSequence)currSearchOrt);
                if (currDistance >= oldDistance) continue;
                foundOrt = currOrt;
                oldDistance = currDistance;
            }
        }
        LOG.debug(String.format("entry found: '%s' (Distance: %s)", foundOrt, oldDistance));
        return foundOrt;
    }

    public static final void addReplaced(Collection<String> coll, String source, String target, String replacement) {
        String rString = StringUtils.trimToEmpty((String)source.replaceAll(target, replacement));
        if (StringUtils.isNotBlank((CharSequence)rString)) {
            coll.add(StringUtils.normalizeSpace((String)StringUtils.lowerCase((String)rString)));
        }
    }

    public static final Collection<String> getAlternatives(String street) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String street1 = StringUtils.normalizeSpace((String)StringUtils.trimToEmpty((String)StringUtils.lowerCase((String)street)).replaceAll("\\.", ". "));
        if (StringUtils.isNotBlank((CharSequence)street1)) {
            result.add(StringUtils.lowerCase((String)street1));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"str.", (String)"stra\u00dfe", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"str.", (String)"strasse", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"stra\u00dfe", (String)"str.", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"stra\u00dfe", (String)"strasse", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"strasse", (String)"str.", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"strasse", (String)"stra\u00dfe", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"str", (String)"stra\u00dfe", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"str", (String)"strasse", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"st.", (String)"sankt", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"sankt", (String)"st.", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"dr.", (String)"doktor", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"doktor", (String)"dr.", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"prof.", (String)"professor", (boolean)true)));
            result.add(StringUtils.lowerCase((String)StringSupport.replace((String)street1, (String)"professor", (String)"prof.", (boolean)true)));
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\u00df", "ss");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\u00e4", "ae");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\u00fc", "ue");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\u00f6", "oe");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\b(an|am|a\\.|auf|in|im|i\\.|dem|der|den|ob)\\b", "");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\b(a|i|d)\\.", "");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bin\\b", "i.");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bi\\.", "in");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bim\\b", "i.");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bi\\.", "im");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bam\\b", "a.");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bauf\\b", "a.");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\ba\\.", "am");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\ba\\.", "auf");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bder\\b", "d.");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bd\\.", "der");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bdem\\b", "d.");
            AdressZuweiserHelper.addReplaced(result, street1, "(?i)\\bd\\.", "dem");
            AdressZuweiserHelper.addReplaced(result, street1, "^(\\.|/|-| )", "");
        }
        result.remove("");
        return result;
    }

    private AdressZuweiserHelper() {
    }
}

