/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.adresszuweiser;

import de.riwagis.util.adresszuweiser.AddressRetrieveDegrationEntry;
import de.riwagis.util.adresszuweiser.AddressRetrieveFilterDef;
import de.riwagis.util.adresszuweiser.AddressRetrieveStrategy;
import de.riwagis.util.adresszuweiser.AdressZuweiserHelper;
import de.riwagis.util.adresszuweiser.AdressZuweiserInput;
import de.riwagis.util.adresszuweiser.AdressZuweiserOutput;
import de.riwagis.util.jdbc.JDBCSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractAddressRetrieveStrategy
implements AddressRetrieveStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAddressRetrieveStrategy.class);
    private final String tablenameHN;

    public AbstractAddressRetrieveStrategy(String tablenameHN) {
        this.tablenameHN = tablenameHN;
    }

    public Collection<AdressZuweiserOutput> readPossibleAddresses(Connection conn, String strSelect, Collection<AddressRetrieveDegrationEntry> degradedAddressSearch, String orderByPart, boolean stopOnFirstMatch) throws SQLException {
        ArrayList<AdressZuweiserOutput> out = new ArrayList<AdressZuweiserOutput>();
        try (Statement stmt = conn.createStatement();){
            ArrayList<AddressRetrieveDegrationEntry> sortedEntries = new ArrayList<AddressRetrieveDegrationEntry>(degradedAddressSearch);
            Collections.sort(sortedEntries, AddressRetrieveDegrationEntry.COMPARE_BY_FITNESS);
            for (AddressRetrieveDegrationEntry currDegration : sortedEntries) {
                String sql = strSelect + " WHERE " + currDegration.getWherePart() + " ORDER BY " + orderByPart;
                try (ResultSet rs = stmt.executeQuery(sql);){
                    while (rs.next()) {
                        AdressZuweiserOutput adressZuweiserOutput = new AdressZuweiserOutput(rs.getString("x"), rs.getString("y"), rs.getString("strasse"), rs.getString("hnr"), rs.getString("addrzusatz"), rs.getString("plz"), rs.getString("ort"), rs.getString("ortzusatz"), rs.getString("g_id"), rs.getString("o_nr"), "", currDegration.getFitnessIndicator());
                        out.add(adressZuweiserOutput);
                    }
                }
                catch (SQLException sqlex) {
                    throw new SQLException(String.format("query '%s' failed: %s", sql, sqlex.getMessage()), sqlex);
                }
                if (out.isEmpty() || !stopOnFirstMatch) continue;
                break;
            }
        }
        return out;
    }

    @Override
    public AdressZuweiserOutput getGeorefAdress(Connection conn, AdressZuweiserInput address) throws SQLException {
        if (address == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)address.getCity()) && StringUtils.isBlank((CharSequence)address.getZipCode())) {
            return null;
        }
        AddressRetrieveFilterDef addressFilterCollection = this.buildAddressFilterCollection(address);
        boolean useHnrZus = true;
        boolean unknownHnr = false;
        Collection<AddressRetrieveDegrationEntry> degradedAddressSearch = AbstractAddressRetrieveStrategy.buildRetrieveEntries(address, true, false, addressFilterCollection);
        String strSelect = this.buildBaseSelect();
        String orderBy = "ort, ortzusatz, strasse, hnrid, addrzusatz";
        ArrayList<AdressZuweiserOutput> out = new ArrayList<AdressZuweiserOutput>();
        out.addAll(this.readPossibleAddresses(conn, strSelect, degradedAddressSearch, "ort, ortzusatz, strasse, hnrid, addrzusatz", true));
        Collections.sort(out, AdressZuweiserOutput.COMPARE_BY_FITNESS);
        LOG.debug(String.format("%d adresses: [%s]", out.size(), out));
        return out.isEmpty() ? null : (AdressZuweiserOutput)out.get(0);
    }

    public AddressRetrieveFilterDef buildAddressFilterCollection(AdressZuweiserInput address) {
        AddressRetrieveFilterDef addressFilterCollection = new AddressRetrieveFilterDef();
        if (StringUtils.isNotBlank((CharSequence)address.getZipCode())) {
            addressFilterCollection.setWherePLZ(String.format("LOWER(LTRIM(RTRIM(CAST(plz AS CHAR(20))))) = '%s'", JDBCSupport.escapeSql(StringUtils.normalizeSpace((String)StringUtils.lowerCase((String)address.getZipCode())))));
        }
        if (StringUtils.isNotBlank((CharSequence)address.getCity())) {
            Collection<String> cityAlternatives = AdressZuweiserHelper.getAlternatives(address.getCity());
            addressFilterCollection.setWhereOrt(JDBCSupport.buildInList("LOWER(LTRIM(RTRIM(REPLACE(ort, ' ', ''))))", AdressZuweiserHelper.removeSpaces(cityAlternatives), "'"));
            addressFilterCollection.setWhereOrtLike("LOWER(LTRIM(RTRIM(ort))) LIKE '%" + JDBCSupport.escapeSql(StringUtils.lowerCase((String)address.getCity())) + "' OR LOWER(LTRIM(RTRIM(ort))) LIKE '" + JDBCSupport.escapeSql(StringUtils.lowerCase((String)address.getCity())) + "%'");
        }
        if (StringUtils.isNotBlank((CharSequence)address.getStreet())) {
            Collection<String> streetAlternatives = AdressZuweiserHelper.getAlternatives(address.getStreet());
            addressFilterCollection.setWhereStreet(JDBCSupport.buildInList("LOWER(LTRIM(RTRIM(REPLACE(strasse, ' ', ''))))", AdressZuweiserHelper.removeSpaces(streetAlternatives), "'"));
            addressFilterCollection.setWhereStreetLike("LOWER(LTRIM(RTRIM(REPLACE(strasse, ' ', '')))) LIKE '%" + JDBCSupport.escapeSql(StringUtils.lowerCase((String)address.getStreet()).replace(" ", "")) + "' OR LOWER(LTRIM(RTRIM(REPLACE(strasse, ' ', '')))) LIKE '" + JDBCSupport.escapeSql(StringUtils.lowerCase((String)address.getStreet()).replace(" ", "")) + "%' ");
        }
        addressFilterCollection.setWhereHnr(String.format("hnrid='%s'", JDBCSupport.escapeSql((String)StringUtils.defaultIfBlank((CharSequence)address.getStreetnumber(), (CharSequence)"-1"))));
        addressFilterCollection.setWhereHnrZus("(addrzusatz IS NULL OR addrzusatz='')");
        if (StringUtils.isNotBlank((CharSequence)address.getStreetnumberSuffix())) {
            addressFilterCollection.setWhereHnrZus(String.format("(%s)", JDBCSupport.buildInList("LOWER(LTRIM(RTRIM(addrzusatz)))", AdressZuweiserHelper.getAlternatives(address.getStreetnumberSuffix()), "'")));
        }
        return addressFilterCollection;
    }

    public static Collection<AddressRetrieveDegrationEntry> buildRetrieveEntries(AdressZuweiserInput addressInput, boolean useHnrZus, boolean allowIgnoredHnr, AddressRetrieveFilterDef filterDef) {
        String caclrRue;
        ArrayList<AddressRetrieveDegrationEntry> degradedAddressSearch = new ArrayList<AddressRetrieveDegrationEntry>();
        if (useHnrZus) {
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(100, filterDef.getWherePLZ(), filterDef.getWhereOrt(), filterDef.getWhereStreet(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(95, filterDef.getWherePLZ(), filterDef.getWhereOrtLike(), filterDef.getWhereStreet(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(95, filterDef.getWherePLZ(), filterDef.getWhereOrt(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(90, filterDef.getWherePLZ(), filterDef.getWhereOrtLike(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
        }
        degradedAddressSearch.add(new AddressRetrieveDegrationEntry(80, filterDef.getWherePLZ(), filterDef.getWhereOrt(), filterDef.getWhereStreet(), filterDef.getWhereHnr()));
        degradedAddressSearch.add(new AddressRetrieveDegrationEntry(75, filterDef.getWherePLZ(), filterDef.getWhereOrtLike(), filterDef.getWhereStreet(), filterDef.getWhereHnr()));
        degradedAddressSearch.add(new AddressRetrieveDegrationEntry(75, filterDef.getWherePLZ(), filterDef.getWhereOrt(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr()));
        degradedAddressSearch.add(new AddressRetrieveDegrationEntry(70, filterDef.getWherePLZ(), filterDef.getWhereOrtLike(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr()));
        if (allowIgnoredHnr) {
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(60, filterDef.getWherePLZ(), filterDef.getWhereOrt(), filterDef.getWhereStreet()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(55, filterDef.getWherePLZ(), filterDef.getWhereOrtLike(), filterDef.getWhereStreet()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(55, filterDef.getWherePLZ(), filterDef.getWhereOrt(), filterDef.getWhereStreetLike()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(50, filterDef.getWherePLZ(), filterDef.getWhereOrtLike(), filterDef.getWhereStreetLike()));
        }
        if (StringUtils.isNotBlank((CharSequence)addressInput.getCity())) {
            if (useHnrZus) {
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(100, filterDef.getWhereOrt(), filterDef.getWhereStreet(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(95, filterDef.getWhereOrtLike(), filterDef.getWhereStreet(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(95, filterDef.getWhereOrt(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(90, filterDef.getWhereOrtLike(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
            }
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(80, filterDef.getWhereOrt(), filterDef.getWhereStreet(), filterDef.getWhereHnr()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(75, filterDef.getWhereOrtLike(), filterDef.getWhereStreet(), filterDef.getWhereHnr()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(75, filterDef.getWhereOrt(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(70, filterDef.getWhereOrtLike(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr()));
            if (allowIgnoredHnr) {
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(60, filterDef.getWhereOrt(), filterDef.getWhereStreet()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(55, filterDef.getWhereOrtLike(), filterDef.getWhereStreet()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(55, filterDef.getWhereOrt(), filterDef.getWhereStreetLike()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(50, filterDef.getWhereOrtLike(), filterDef.getWhereStreetLike()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)addressInput.getZipCode())) {
            if (useHnrZus) {
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(100, filterDef.getWherePLZ(), filterDef.getWhereStreet(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(95, filterDef.getWherePLZ(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
            }
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(80, filterDef.getWherePLZ(), filterDef.getWhereStreet(), filterDef.getWhereHnr()));
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(75, filterDef.getWherePLZ(), filterDef.getWhereStreetLike(), filterDef.getWhereHnr()));
            if (allowIgnoredHnr) {
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(60, filterDef.getWherePLZ(), filterDef.getWhereStreet()));
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(55, filterDef.getWherePLZ(), filterDef.getWhereStreetLike()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(caclrRue = addressInput.getOptionalValue("CACLR_RUE")))) {
            String caclrRueFilter = String.format("id_caclr_rue=%s", caclrRue);
            if (useHnrZus) {
                degradedAddressSearch.add(new AddressRetrieveDegrationEntry(110, caclrRueFilter, filterDef.getWhereHnr(), filterDef.getWhereHnrZus()));
            }
            degradedAddressSearch.add(new AddressRetrieveDegrationEntry(105, caclrRueFilter, filterDef.getWhereHnr()));
        }
        return degradedAddressSearch;
    }

    public String getHNTablename() {
        return this.tablenameHN;
    }
}

