/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.file.TempFileOutputStream;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhiteboardImpl
implements Whiteboard {
    public static final long serialVersionUID = -3459059109542189070L;
    private static final Logger LOG = LoggerFactory.getLogger(WhiteboardImpl.class);
    private final Map<String, Object> atts = new HashMap<String, Object>();
    public static final Charset WHITEBOARD_ENC = StandardCharsets.UTF_8;

    @Deprecated
    public static final Whiteboard createWhiteboard(Reader wbReader) {
        WhiteboardImpl wb = new WhiteboardImpl();
        WhiteboardImpl.readWhiteboard(wb, wbReader, WhiteboardImpl.createDefaultXStream());
        return wb;
    }

    public static final Whiteboard createWhiteboard(Reader wbReader, XStream xstream) {
        WhiteboardImpl wb = new WhiteboardImpl();
        WhiteboardImpl.readWhiteboard(wb, wbReader, xstream);
        return wb;
    }

    @Deprecated
    public static Whiteboard createWhiteboard(File wbfile) {
        WhiteboardImpl wb = new WhiteboardImpl();
        WhiteboardImpl.readFromFile(wb, wbfile, WhiteboardImpl.createDefaultXStream());
        return wb;
    }

    public static Whiteboard createWhiteboard(File wbfile, XStream xstream) {
        WhiteboardImpl wb = new WhiteboardImpl();
        WhiteboardImpl.readFromFile(wb, wbfile, xstream);
        return wb;
    }

    public static Whiteboard createWhiteboard(Map<String, Object> _atts) {
        WhiteboardImpl wb = new WhiteboardImpl();
        wb.resetAttributes(_atts);
        return wb;
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.atts);
    }

    protected final void resetAttributes(Map<String, Object> atts) {
        this.removeAll();
        this.addAllAttributes(atts);
    }

    public Whiteboard addAllAttributes(Map<String, Object> properties) {
        this.atts.putAll(properties);
        return this;
    }

    public void remove(String key) {
        this.atts.remove(key);
    }

    public void removeAll() {
        this.atts.clear();
    }

    public boolean contains(String key) {
        return this.atts.containsKey(key);
    }

    public Whiteboard setAttribute(String key, Object value) {
        this.atts.put(key, value);
        return this;
    }

    public boolean hasAttribute(String key) {
        return this.atts.get(key) != null;
    }

    public Object getAttribute(String key) {
        return this.atts.get(key);
    }

    public Whiteboard setAttribute(String key, boolean value) {
        this.setAttribute(key, (Object)value);
        return this;
    }

    public boolean get(String key, boolean defaultvalue) {
        if (this.getAttribute(key) == null) {
            this.setAttribute(key, defaultvalue);
        }
        return this.getBoolean(key);
    }

    private boolean getBoolean(String key) {
        return (Boolean)this.getAttribute(key);
    }

    public Whiteboard setAttribute(String key, int value) {
        this.setAttribute(key, (Object)value);
        return this;
    }

    public Whiteboard setAttribute(String key, double value) {
        this.setAttribute(key, (Object)value);
        return this;
    }

    public double getAttribute(String key, double defaultValue) {
        if (this.getAttribute(key) == null) {
            this.setAttribute(key, defaultValue);
        }
        return this.getDouble(key);
    }

    public int getAttribute(String key, int defaultValue) {
        if (this.getAttribute(key) == null) {
            this.setAttribute(key, defaultValue);
        }
        return this.getInt(key);
    }

    public int getInt(String key) {
        return (Integer)this.getAttribute(key);
    }

    public double getDouble(String key) {
        return (Double)this.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        if (this.getAttribute(key) == null) {
            this.setAttribute(key, defaultValue);
        }
        return this.getAttribute(key);
    }

    public Whiteboard setFileAttribute(String key, File value) {
        return this.setAttribute(key, value);
    }

    public File getFileAttribute(String key, File defaultValue) {
        Object res = this.getAttribute(key, defaultValue);
        if (res instanceof File) {
            LOG.debug("Whiteboard-Entry at key '" + key + "' is File: " + res);
            return (File)res;
        }
        if (res instanceof String) {
            LOG.debug("Using String-Whiteboard-Entry at key '" + key + "' as File: " + res);
            return new File((String)res);
        }
        LOG.warn("Whiteboard-Entry at key '" + key + "' is not a File: " + res);
        return defaultValue;
    }

    @Deprecated
    protected static void readWhiteboard(Whiteboard wb, Reader wbReader) {
        WhiteboardImpl.readWhiteboard(wb, wbReader, WhiteboardImpl.createDefaultXStream());
    }

    protected static void readWhiteboard(Whiteboard wb, Reader wbReader, XStream xstream) {
        wb.removeAll();
        wb.addAllAttributes((Map)xstream.fromXML(wbReader));
    }

    @Deprecated
    protected static void writeWhiteboard(Whiteboard wb, Writer wbWriter) {
        WhiteboardImpl.writeWhiteboard(wb, wbWriter, WhiteboardImpl.createDefaultXStream());
    }

    protected static void writeWhiteboard(Whiteboard wb, Writer wbWriter, XStream xstream) {
        xstream.marshal((Object)wb.getAttributes(), (HierarchicalStreamWriter)new CompactWriter(wbWriter));
    }

    @Deprecated
    public static void readFromFile(Whiteboard wb, File wbfile) {
        WhiteboardImpl.readFromFile(wb, wbfile, WhiteboardImpl.createDefaultXStream());
    }

    public static void readFromFile(Whiteboard wb, File wbfile, XStream xstream) {
        try {
            LOG.info("Reading whiteboard-file: " + wbfile);
            try (FileInputStream fis = new FileInputStream(wbfile);
                 InputStreamReader reader = new InputStreamReader((InputStream)fis, WHITEBOARD_ENC);){
                WhiteboardImpl.readWhiteboard(wb, reader, xstream);
            }
        }
        catch (IOException e) {
            LOG.debug("Error reading whiteboard-file", (Throwable)e);
            wb.removeAll();
        }
    }

    @Deprecated
    public static boolean writeToFile(Whiteboard wb, File wbfile) {
        return WhiteboardImpl.writeToFile(wb, wbfile, WhiteboardImpl.createDefaultXStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(Whiteboard wb, File wbfile, XStream xstream) {
        try {
            File wbParentDir;
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
                Desktop.getDesktop().disableSuddenTermination();
            }
            if (!(wbParentDir = wbfile.getParentFile()).exists()) {
                FileUtils.forceMkdir((File)wbParentDir);
            }
            LOG.info("Writing whiteboard-file: " + wbfile);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new TempFileOutputStream(wbfile), WHITEBOARD_ENC);){
                WhiteboardImpl.writeWhiteboard(wb, writer, xstream);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Error writing whiteboard: " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
                Desktop.getDesktop().enableSuddenTermination();
            }
        }
    }

    public Object clone() {
        return WhiteboardImpl.createWhiteboard(this.atts);
    }

    private static XStream createDefaultXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.addPermission(ArrayTypePermission.ARRAYS);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypeHierarchy(File.class);
        xstream.allowTypes(new Class[]{String.class});
        xstream.allowTypesByWildcard(new String[]{"de.riwagis.**"});
        return xstream;
    }
}

