/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import de.riwagis.util.exception.SystemException;
import de.riwagis.util.network.NetworkSupport;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Support {
    public static final byte[] ENC_KEY = new byte[]{2, 48, -22, 3, 23, -23, 23, -23};
    public static final String ONE_WAY_ENC = "SHA-1";
    public static final String ONE_WAY_ENC_SECURE = "PBKDF2WithHmacSHA512";
    public static final int ITERATIONS = 50000;
    public static final int SALT_LENGTH = 32;
    public static final int HASH_LENGTH = 512;

    public static boolean isJavaVersionAtLeast(String strVerion) {
        String strJV = System.getProperty("java.version");
        List<Float> arrJavaFlt = Support.determineFloatVersionParts(strJV);
        List<Float> arrJavaCompFlt = Support.determineFloatVersionParts(strVerion);
        int maxIndex = Math.min(arrJavaFlt.size(), arrJavaCompFlt.size());
        for (int i = 0; i < maxIndex; ++i) {
            if (arrJavaCompFlt.get(i).floatValue() < arrJavaFlt.get(i).floatValue()) {
                return true;
            }
            if (arrJavaCompFlt.get(i) == arrJavaFlt.get(i)) continue;
            return false;
        }
        return true;
    }

    public static List<Float> determineFloatVersionParts(String strJV) throws NumberFormatException {
        ArrayList<Float> arrJavaFlt = new ArrayList<Float>();
        for (String arrJava1 : strJV.replaceAll("([_-]|ea)", "").split("\\.")) {
            arrJavaFlt.add(Float.valueOf(Float.parseFloat(arrJava1)));
        }
        ArrayList arrJavaCompFlt = new ArrayList();
        return arrJavaFlt;
    }

    public static String encryptOneWay(String password, String strAlg) throws SystemException {
        return Support.encryptOneWay(StringUtils.defaultString((String)password).toCharArray(), strAlg);
    }

    public static String encryptOneWay(char[] password, String strAlg) throws SystemException {
        try {
            if (strAlg != null && strAlg.equals(ONE_WAY_ENC_SECURE)) {
                return Support.hashPassword(password, Support.getRandomBytes(32), 50000, 512);
            }
            MessageDigest md = MessageDigest.getInstance(strAlg);
            byte[] data = new byte[password.length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = Support.toByte(password[i]);
            }
            byte[] encdata = md.digest(data);
            String hash = new String(new Base64().encode(encdata));
            return hash;
        }
        catch (Exception e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
    }

    public static String hashPassword(String password) throws SystemException {
        return Support.hashPassword(StringUtils.defaultString((String)password).toCharArray(), Support.getRandomBytes(32), 50000, 512);
    }

    public static String hashPassword(char[] password, byte[] salt, int iterations, int keyLength) throws SystemException {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(ONE_WAY_ENC_SECURE);
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLength);
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return Integer.toHexString(iterations) + ":" + new String(new Base64().encode(salt)) + ":" + new String(new Base64().encode(hash));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
    }

    public static boolean verifyPassword(String pwd, String storedPwd) throws SystemException {
        try {
            String[] parts = storedPwd.split(":");
            int iterations = Integer.parseInt(parts[0], 16);
            byte[] salt = new Base64().decode(parts[1]);
            byte[] hash = new Base64().decode(parts[2]);
            PBEKeySpec spec = new PBEKeySpec(StringUtils.defaultString((String)pwd).toCharArray(), salt, iterations, hash.length * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(ONE_WAY_ENC_SECURE);
            byte[] testHash = skf.generateSecret(spec).getEncoded();
            int diff = hash.length ^ testHash.length;
            for (int i = 0; i < hash.length && i < testHash.length; ++i) {
                diff |= hash[i] ^ testHash[i];
            }
            return diff == 0;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public static byte[] encryptFromString(String pwd, byte[] arrKey) throws SystemException {
        return Support.encrypt(pwd.toCharArray(), arrKey);
    }

    @Deprecated
    public static byte[] encrypt(char[] chrData, byte[] arrKey) throws SystemException {
        try {
            SecretKeySpec k = new SecretKeySpec(arrKey, "DES");
            Cipher c = Cipher.getInstance("DES");
            c.init(1, k);
            byte[] data = new byte[chrData.length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = Support.toByte(chrData[i]);
            }
            return c.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] getKeyByString(String strKey) throws SystemException {
        try {
            byte[] arrStrBytes = strKey.getBytes();
            byte[] arrKey = new byte[8];
            for (int i = 0; i < arrKey.length; ++i) {
                if (arrStrBytes.length > i) {
                    if (i % 3 != 0) {
                        arrKey[i] = arrStrBytes[i];
                        continue;
                    }
                    arrKey[i] = (byte)i;
                    continue;
                }
                arrKey[i] = (byte)i;
            }
            return arrKey;
        }
        catch (Exception e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] getKeyByMacAdress() throws SystemException {
        try {
            byte[] arrMac = NetworkSupport.getMACAdress();
            byte[] arrKey = new byte[8];
            System.arraycopy(arrMac, 0, arrKey, 0, arrMac.length);
            arrKey[6] = 50;
            arrKey[7] = -102;
            return arrKey;
        }
        catch (Exception e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] getRandomBytes(int length) {
        SecureRandom random = new SecureRandom();
        byte[] rndBytes = new byte[length];
        random.nextBytes(rndBytes);
        return rndBytes;
    }

    @Deprecated
    public static String decryptToString(byte[] data, byte[] arrKey) throws SystemException {
        return new String(Support.decrypt(data, arrKey));
    }

    @Deprecated
    public static char[] decrypt(byte[] data, byte[] arrKey) throws SystemException {
        try {
            SecretKeySpec k = new SecretKeySpec(arrKey, "DES");
            Cipher c = Cipher.getInstance("DES");
            c.init(2, k);
            byte[] oriData = c.doFinal(data);
            char[] chrOriData = new char[oriData.length];
            for (int i = 0; i < oriData.length; ++i) {
                chrOriData[i] = Support.toChar(oriData[i]);
            }
            return chrOriData;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SystemException(Support.class, e.getMessage(), (Throwable)e);
        }
    }

    public static char toChar(byte bte) {
        return (char)(bte & 0xFF);
    }

    public static byte toByte(char chr) {
        return (byte)(chr & 0xFF);
    }

    public static String getDateTime(Locale loc) {
        Date myDate = new Date();
        String strDate = DateFormat.getDateTimeInstance().format(myDate);
        return strDate;
    }

    public static String getDate(Locale loc) {
        Date myDate = new Date();
        DateFormat df = DateFormat.getDateInstance(3, loc);
        String strDate = df.format(myDate);
        return strDate;
    }

    public static String getDate(String strFormat) {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat(strFormat);
        df.setTimeZone(TimeZone.getDefault());
        return df.format(dt);
    }

    public static String getTimeString() {
        Date dt = new Date();
        return "" + dt.getTime();
    }

    @Deprecated
    public static String toString(Object obj) {
        return ObjectUtils.toString((Object)obj);
    }

    public static int toInt(Object obj) {
        return Integer.parseInt(ObjectUtils.toString((Object)obj, (String)"0"));
    }

    @Deprecated
    public static String beginWithChar(String str, char chr, int length) {
        return StringUtils.leftPad((String)StringUtils.defaultString((String)str), (int)length, (char)chr);
    }

    public static void shellSort(String[][] a, int sortindex) throws Exception {
        if (sortindex < 0) {
            throw new IllegalArgumentException("Sortindex must not be smaller than 0 (zero): " + sortindex);
        }
        int h = 1;
        if (a != null && a.length > 0) {
            while (h < a[sortindex].length) {
                h = 3 * h + 1;
            }
            while (h > 0) {
                for (int i = h = (h - 1) / 3; i < a[sortindex].length; ++i) {
                    int x;
                    String[] strtemp = new String[a.length];
                    for (int x2 = 0; x2 < strtemp.length; ++x2) {
                        strtemp[x2] = a[x2][i];
                    }
                    for (int j = i - h; j >= 0 && ObjectUtils.toString((Object)strtemp[sortindex]).compareTo(ObjectUtils.toString((Object)a[sortindex][j])) < 0; j -= h) {
                        for (x = 0; x < strtemp.length; ++x) {
                            a[x][j + h] = a[x][j];
                        }
                    }
                    for (x = 0; x < strtemp.length; ++x) {
                        a[x][j + h] = strtemp[x];
                    }
                }
            }
        }
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").equalsIgnoreCase("linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

