/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util;

import de.riwagis.util.PropertiesSupport;
import de.riwagis.util.file.TempFileOutputStream;
import de.riwagis.util.geom.Dimension2DDouble;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public final class ConfigUtil {
    public static final Charset DEFAULT_PROPERTIES_ENCODING = PropertiesSupport.DEFAULT_PROPERTIES_ENCODING;

    public static Dimension2D parseDimension(String dimension) {
        return ConfigUtil.parseDimension(dimension, ",");
    }

    public static Dimension2D parseDimension(String dimension, String separator) {
        if (StringUtils.isNotBlank((CharSequence)dimension)) {
            StringTokenizer tok = new StringTokenizer(dimension.trim(), separator);
            if (tok.countTokens() == 2) {
                Dimension2DDouble dim = new Dimension2DDouble(Double.parseDouble(tok.nextToken().trim()), Double.parseDouble(tok.nextToken().trim()));
                return dim;
            }
            throw new IllegalArgumentException(String.format("Not a dimension: %s (Separator: %s)", dimension, separator));
        }
        return null;
    }

    public static boolean parseBoolean(String boolStr, boolean defValue) {
        if (boolStr != null) {
            return BooleanUtils.toBoolean((String)boolStr);
        }
        return defValue;
    }

    public static Point2D parsePoint(String pointText, String separator) {
        Point2D.Double dim = null;
        if (StringUtils.isNotBlank((CharSequence)pointText)) {
            StringTokenizer tok = new StringTokenizer(pointText.trim(), separator);
            if (tok.countTokens() == 2) {
                try {
                    dim = new Point2D.Double(Double.parseDouble(tok.nextToken().trim()), Double.parseDouble(tok.nextToken().trim()));
                }
                catch (NumberFormatException nfex) {
                    throw new IllegalArgumentException(String.format("Not a valid point: %s (Separator: %s)", pointText, separator), nfex);
                }
            } else {
                throw new IllegalArgumentException(String.format("Not a valid point: %s (Separator: %s)", pointText, separator));
            }
        }
        return dim;
    }

    @Deprecated
    public static final Properties loadPropertiesFromFile(File propertyFile) throws IOException {
        return PropertiesSupport.loadProperties((File)propertyFile);
    }

    @Deprecated
    public static final Properties loadPropertiesFromFile(File propertyFile, Charset encoding) throws IOException {
        return PropertiesSupport.loadProperties((File)propertyFile, (Charset)encoding);
    }

    @Deprecated
    public static void loadPropertiesFromFile(Properties properties, File propertyFile) throws IOException {
        PropertiesSupport.loadProperties((Properties)properties, (File)propertyFile);
    }

    @Deprecated
    public static void loadPropertiesFromFile(Properties properties, File propertyFile, Charset encoding) throws IOException {
        PropertiesSupport.loadProperties((Properties)properties, (File)propertyFile, (Charset)encoding);
    }

    public static void storePropertiesToFile(Properties properties, File propertyFile, String comments) throws IOException {
        ConfigUtil.storePropertiesToFile(properties, propertyFile, comments, DEFAULT_PROPERTIES_ENCODING);
    }

    public static void storePropertiesToFile(Properties properties, File propertyFile, String comments, Charset encoding) throws IOException {
        try (TempFileOutputStream tmpOS = new TempFileOutputStream(propertyFile);
             OutputStreamWriter osW = new OutputStreamWriter((OutputStream)tmpOS, encoding);){
            properties.store(osW, comments);
        }
    }

    public static void storePropertiesToFile(Properties properties, File propertyFile) throws IOException {
        ConfigUtil.storePropertiesToFile(properties, propertyFile, DEFAULT_PROPERTIES_ENCODING);
    }

    public static void storePropertiesToFile(Properties properties, File propertyFile, Charset encoding) throws IOException {
        PropertiesSupport.storeProperties((Properties)properties, (File)propertyFile, (Charset)encoding);
    }

    private ConfigUtil() {
    }
}

