/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.localdb;

import de.riwagis.util.db.LocalDBUtils;
import de.riwagis.util.localdb.DataTransform;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDBBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDBBuilder.class);
    private static final QueryRunner qr = new QueryRunner();

    public static void fromList(Connection conn, Map<String, Object> data) throws IOException, SQLException {
        LOG.info(String.format("building database to %s", conn.getMetaData().getURL()));
        LinkedHashMap<String, Collection<Map<String, String>>> tables = new LinkedHashMap<String, Collection<Map<String, String>>>();
        List<Map<String, Object>> topData = Arrays.asList(data);
        DataTransform.buildTables("topmosttable", tables, topData, "", "");
        DataTransform.markLargeColumns(tables);
        LOG.info(String.format("%d tables extracted: %s", tables.size(), tables.keySet()));
        for (String currTableName : tables.keySet()) {
            Collection tableData = (Collection)tables.get(currTableName);
            List<String> columns = DataTransform.determineColumnNames(tableData);
            LocalDBBuilder.buildDBSchema(conn, currTableName, columns);
            LocalDBBuilder.insertDBData(conn, currTableName, columns, tableData);
        }
    }

    public static void insertDBData(Connection conn, String tableName, List<String> columns, Collection<Map<String, String>> tableData) throws SQLException {
        if (!columns.isEmpty()) {
            ArrayList<String> cleanedColumns = new ArrayList<String>();
            for (String currColumn : columns) {
                if (StringUtils.startsWithAny((CharSequence)currColumn, (CharSequence[])new String[]{"!", "\u00a7"})) {
                    cleanedColumns.add(StringUtils.substring((String)currColumn, (int)1));
                    continue;
                }
                cleanedColumns.add(currColumn);
            }
            int rows = 0;
            try (PreparedStatement pstmt = conn.prepareStatement(LocalDBUtils.buildInsertSQL(tableName, cleanedColumns));){
                for (Map<String, String> currDataRow : tableData) {
                    int i = 1;
                    for (String currColumnName : columns) {
                        pstmt.setString(i, currDataRow.get(currColumnName));
                        ++i;
                    }
                    rows += pstmt.executeUpdate();
                }
            }
            LOG.info(String.format("rows inserted in table '%s': %d ", tableName, rows));
        }
    }

    public static void buildDBSchema(Connection conn, String tableName, Collection<String> columns) throws SQLException {
        if (!columns.isEmpty()) {
            LinkedHashSet<String> columnsSQLType = new LinkedHashSet<String>();
            for (String currColumnName : columns) {
                String colname;
                if (StringUtils.startsWith((CharSequence)currColumnName, (CharSequence)"!")) {
                    colname = StringUtils.substring((String)currColumnName, (int)1);
                    columnsSQLType.add(String.format("%s INTEGER", colname));
                    continue;
                }
                if (StringUtils.startsWith((CharSequence)currColumnName, (CharSequence)"\u00a7")) {
                    colname = StringUtils.substring((String)currColumnName, (int)1);
                    columnsSQLType.add(String.format("%s LONGVARCHAR", colname));
                    continue;
                }
                colname = currColumnName;
                columnsSQLType.add(String.format("%s VARCHAR(2000)", colname));
            }
            columnsSQLType.add("PRIMARY KEY (ID)");
            String dropStatement = String.format("DROP TABLE IF EXISTS %s", tableName);
            LOG.info(String.format("drop table '%s': '%s'", tableName, dropStatement));
            qr.update(conn, dropStatement);
            String createStatement = String.format("CREATE TABLE %s (%s)", tableName, StringUtils.join(columnsSQLType, (String)", "));
            LOG.info(String.format("create table '%s': '%s'", tableName, createStatement));
            qr.update(conn, createStatement);
        }
    }

    private LocalDBBuilder() {
    }
}

