/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.localdb;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;

public class HSQLDBUtils {
    public static final String EXTENSION_BAK = "bak";
    public static final String EXTENSION_ALLFILES = "*";

    public static void backupHSQLDB(File databaseFile) throws IOException {
        File dirDB = databaseFile.getParentFile();
        String databaseFilename = databaseFile.getName();
        FileFilter fileFilter = HSQLDBUtils.buildWildcardFilter(databaseFilename);
        for (File currentDatabaseFile : dirDB.listFiles(fileFilter)) {
            String currFilename = currentDatabaseFile.getName();
            if (HSQLDBUtils.hasExtension(currFilename, EXTENSION_BAK)) continue;
            String currBAKFilename = HSQLDBUtils.addExtension(currFilename, EXTENSION_BAK);
            File currBAKFile = new File(dirDB, currBAKFilename);
            FileUtils.deleteQuietly((File)currBAKFile);
            FileUtils.moveFile((File)currentDatabaseFile, (File)currBAKFile);
        }
    }

    public static String addExtension(String filename, String extension) {
        return String.format("%s.%s", filename, extension);
    }

    public static boolean hasExtension(String filename, String testExtension) {
        return StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getExtension((String)filename), (CharSequence)testExtension);
    }

    public static void deleteHSQLDB(File databaseFile) {
        File dirDB = databaseFile.getParentFile();
        String databaseFilename = databaseFile.getName();
        FileFilter fileFilter = HSQLDBUtils.buildWildcardFilter(databaseFilename);
        for (File currentDatabaseFile : dirDB.listFiles(fileFilter)) {
            if (HSQLDBUtils.hasExtension(currentDatabaseFile.getName(), EXTENSION_BAK)) continue;
            FileUtils.deleteQuietly((File)currentDatabaseFile);
        }
    }

    public static FileFilter buildWildcardFilter(String baseFilename) {
        String filterString = HSQLDBUtils.addExtension(baseFilename, EXTENSION_ALLFILES);
        return new WildcardFileFilter(filterString);
    }

    public static Connection createHSQLDBConnection(File databaseFile) throws SQLException {
        String databaseURL = String.format("jdbc:hsqldb:file://%s;shutdown=true;default_schema=true", StringUtils.replace((String)databaseFile.getAbsolutePath(), (String)"\\", (String)"\\\\"));
        return DriverManager.getConnection(databaseURL);
    }

    private HSQLDBUtils() {
    }
}

