/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.localdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DataTransform {
    public static final void markLargeColumns(Map<String, Collection<Map<String, String>>> tables) {
        for (Map.Entry<String, Collection<Map<String, String>>> currTable : tables.entrySet()) {
            LinkedHashMap<String, Integer> maxValLength = new LinkedHashMap<String, Integer>();
            for (Map<String, String> map : currTable.getValue()) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    Integer currentMaxLength = (Integer)maxValLength.get(entry.getKey());
                    if (currentMaxLength == null) {
                        currentMaxLength = 0;
                    }
                    maxValLength.put(entry.getKey(), Math.max(currentMaxLength, StringUtils.length((CharSequence)entry.getValue())));
                }
            }
            for (Map.Entry entry : maxValLength.entrySet()) {
                if ((Integer)entry.getValue() <= 1900) continue;
                for (Map map : currTable.getValue()) {
                    map.put(String.format("\u00a7%s", entry.getKey()), (String)map.remove(entry.getKey()));
                }
            }
        }
    }

    public static final void buildTables(String tablename, Map<String, Collection<Map<String, String>>> tables, Collection<Map<String, Object>> data, String refColumn, String refKey) {
        if (!tables.containsKey(tablename)) {
            tables.put(tablename, new ArrayList());
        }
        Collection<Map<String, String>> currTable = tables.get(tablename);
        for (Map<String, Object> currDataEntry : data) {
            LinkedHashMap<String, String> currTableRow = new LinkedHashMap<String, String>();
            currTable.add(currTableRow);
            String currRowID = Integer.toString(currTable.size());
            currTableRow.put("!ID", currRowID);
            if (StringUtils.isNotBlank((CharSequence)refKey) && StringUtils.isNotBlank((CharSequence)refColumn)) {
                currTableRow.put(refColumn, refKey);
            }
            for (Map.Entry<String, Object> currEntry : currDataEntry.entrySet()) {
                if (currEntry.getValue() instanceof Collection) {
                    String subTableName = currEntry.getKey();
                    Collection subData = (Collection)currEntry.getValue();
                    DataTransform.buildTables(subTableName, tables, subData, String.format("!ID_%s", tablename), currRowID);
                }
                if (currEntry.getValue() instanceof String) {
                    currTableRow.put(currEntry.getKey(), (String)currEntry.getValue());
                }
                if (!(currEntry.getValue() instanceof String[])) continue;
                currTableRow.put(currEntry.getKey(), ((String[])currEntry.getValue())[0]);
            }
        }
    }

    public static List<String> determineColumnNames(Collection<Map<String, String>> tableData) {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (Map<String, String> currDataRow : tableData) {
            columns.addAll(currDataRow.keySet());
        }
        return new ArrayList<String>(columns);
    }

    private DataTransform() {
    }
}

