/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context.map.debug;

import de.riwagis.gis.context.map.debug.DebugInformation;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInformations {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebugInformations.class);

    public static DebugInformation createPathInformation(String key, String displayName, Path path) {
        return new BasicDebugInformation(key, displayName, path.toAbsolutePath().toString(), () -> DebugInformations.openFile(path.toFile()));
    }

    public static DebugInformation createFileInformation(String key, String displayName, File file) {
        return new BasicDebugInformation(key, displayName, file.getAbsolutePath(), () -> DebugInformations.openFile(file));
    }

    public static DebugInformation createStringInformation(String key, String displayName, Object value) {
        return new BasicDebugInformation(key, displayName, Objects.toString(value, ""), () -> DebugInformations.copyToClipboard(value));
    }

    private static void copyToClipboard(Object value) {
        StringSelection selection = new StringSelection(value.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private static void openFile(File file) {
        try {
            if (file.exists()) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (IOException e) {
            log.error("Could not open URI {}", (Object)file);
        }
    }

    private static class BasicDebugInformation
    implements DebugInformation {
        private final String key;
        private final String displayName;
        private final Runnable doubleClickAction;
        private final String displayValue;

        private BasicDebugInformation(String key, String displayName, String displayValue, Runnable doubleClickAction) {
            this.key = key;
            this.displayName = displayName;
            this.doubleClickAction = doubleClickAction;
            this.displayValue = displayValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getDisplayKey() {
            return this.displayName;
        }

        @Override
        public String getDisplayValue() {
            return this.displayValue;
        }

        @Override
        public void doDoubleClickAction() {
            this.doubleClickAction.run();
        }

        public String toString() {
            return "BasicDebugInformation{key='" + this.key + "', displayName='" + this.displayName + "', doubleClickAction=" + String.valueOf(this.doubleClickAction) + ", displayValue='" + this.displayValue + "'}";
        }
    }
}

