/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.gis.context;

import de.riwagis.gis.context.GisContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class AppStartup {
    public static GisContext gisContext = new GisContext(){};
    private static Element moduleElem = null;
    private static Element mapElem = null;

    private AppStartup() {
    }

    public static boolean isMapUp() {
        return gisContext.getMapApp() != null;
    }

    public static void startUpMap() throws Exception {
        if (AppStartup.isMapUp()) {
            return;
        }
        if (mapElem != null) {
            AppStartup.startup(mapElem, mapElem.getNamespace(), new String[0]);
        }
    }

    public static void startUpMap(String[] args) throws Exception {
        if (AppStartup.isMapUp()) {
            return;
        }
        if (mapElem != null) {
            AppStartup.startup(mapElem, mapElem.getNamespace(), args);
        }
    }

    public static boolean isModuleUp() {
        return gisContext.getModuleApp() != null;
    }

    public static void startUpModule() throws Exception {
        if (AppStartup.isModuleUp()) {
            return;
        }
        if (moduleElem != null) {
            AppStartup.startup(moduleElem, moduleElem.getNamespace(), new String[0]);
        }
    }

    public static void main(String[] args) {
        try {
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build("gisinterface.xml");
            Namespace ns = doc.getRootElement().getNamespace();
            mapElem = doc.getRootElement().getChild("mapapp", ns);
            moduleElem = doc.getRootElement().getChild("moduleapp", ns);
            Element startElem = mapElem.getChild("startup", ns);
            if (startElem != null) {
                AppStartup.startup(mapElem, ns, args);
            } else {
                AppStartup.startup(moduleElem, ns, args);
            }
        }
        catch (Exception e) {
            System.out.println("--------------------Fehler bei AppStartup");
            e.printStackTrace(System.out);
            System.out.println("--------------------");
            JOptionPane.showMessageDialog(null, String.format("Error in GisInterface - AppStartup: %s", e.getMessage()), "error", -1);
            System.exit(0);
        }
    }

    private static void startup(Element elem, Namespace ns, String[] args) throws Exception {
        String[] arrParam;
        String strClass = elem.getChildTextTrim("class", ns);
        String strMeth = elem.getChildTextTrim("method", ns);
        try {
            Iterator i = elem.getChild("args", ns).getChildren("arg", ns).iterator();
            ArrayList<String> lstParam = new ArrayList<String>();
            while (i.hasNext()) {
                Element argElem = (Element)i.next();
                lstParam.add(argElem.getText());
            }
            lstParam.addAll(Arrays.asList(args));
            arrParam = lstParam.toArray(new String[lstParam.size()]);
        }
        catch (Exception e) {
            arrParam = new String[]{};
        }
        Class<?> elemClass = Class.forName(strClass);
        Class[] arrClass = new Class[]{String[].class, GisContext.class};
        Method meth = elemClass.getMethod(strMeth, arrClass);
        meth.invoke(null, arrParam, gisContext);
    }
}

