/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.jdom;

import de.riwagis.util.file.TempFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDOMUtils {
    private static final Logger log = LoggerFactory.getLogger(JDOMUtils.class);
    private static final ThreadLocal<SAXBuilder> SAX_BUILDER = ThreadLocal.withInitial(() -> {
        SAXBuilder sxB = new SAXBuilder();
        sxB.setFeature("http://xml.org/sax/features/validation", false);
        sxB.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return sxB;
    });

    public static Document buildFromText(String string) throws JDOMException, IOException {
        try (StringReader r = new StringReader(string);){
            Document document = JDOMUtils.build(r);
            return document;
        }
    }

    @Deprecated
    public static List<Element> findElementsXPath(Document xmlDoc, Namespace ns, String strXPath) throws JDOMException {
        return JDOMUtils.findElementsXPathObj(xmlDoc, ns, strXPath);
    }

    @Deprecated
    public static List<Element> findElementsXPath(Element rootElement, Namespace ns, String strXPath) throws JDOMException {
        return JDOMUtils.findElementsXPathObj(rootElement, ns, strXPath);
    }

    @Deprecated
    private static List<Element> findElementsXPathObj(Object rootElement, Namespace ns, String strXPath) throws JDOMException {
        ArrayList<Element> res = new ArrayList<Element>();
        XPath xpath = XPath.newInstance((String)strXPath);
        xpath.addNamespace(ns);
        for (Object currElemObj : xpath.selectNodes(rootElement)) {
            if (!(currElemObj instanceof Element)) continue;
            res.add((Element)currElemObj);
        }
        return res;
    }

    public static Collection<Element> getChildElements(Element parentElement) {
        ArrayList<Element> res = new ArrayList<Element>();
        for (Object currNodeObj : parentElement.getChildren()) {
            if (!(currNodeObj instanceof Element)) continue;
            res.add((Element)currNodeObj);
        }
        return res;
    }

    public static Collection<Element> getChildElements(Element parentElement, String elementName) {
        return JDOMUtils.getChildElements(parentElement, parentElement.getNamespace(), elementName);
    }

    public static Collection<Element> getChildElements(Element parentElement, Namespace ns, String elementName) {
        ArrayList<Element> res = new ArrayList<Element>();
        for (Object currNodeObj : parentElement.getChildren(elementName, ns)) {
            if (!(currNodeObj instanceof Element)) continue;
            res.add((Element)currNodeObj);
        }
        return res;
    }

    public static String outputAsString(Document d) {
        return JDOMUtils.outputAsString(JDOMUtils.buildCompactXMLOutputter(), d);
    }

    public static String outputAsString(XMLOutputter op, Document d) {
        String string;
        StringWriter w = new StringWriter();
        try {
            JDOMUtils.outputXML(op, d, w);
            string = w.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    w.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioex) {
                log.warn(String.format("error writing xml document to String: %s", ioex.getMessage()), (Throwable)ioex);
                return "";
            }
        }
        w.close();
        return string;
    }

    public static final String outputAsString(Element element) {
        return JDOMUtils.outputAsString(JDOMUtils.buildCompactXMLOutputter(), element);
    }

    public static String outputAsString(XMLOutputter op, Element element) {
        String string;
        StringWriter w = new StringWriter();
        try {
            op.output(element, (Writer)w);
            string = w.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    w.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioex) {
                log.warn(String.format("error writing xml element to String: %s", ioex.getMessage()), (Throwable)ioex);
                return "";
            }
        }
        w.close();
        return string;
    }

    private JDOMUtils() {
    }

    public static XMLOutputter buildPrettyPrintXMLOutputter() {
        return JDOMUtils.buildPrettyPrintXMLOutputter(StandardCharsets.UTF_8.name());
    }

    public static XMLOutputter buildCompactXMLOutputter() {
        return JDOMUtils.buildCompactXMLOutputter(StandardCharsets.UTF_8.name());
    }

    public static XMLOutputter buildPrettyPrintXMLOutputter(String strCharset) {
        XMLOutputter out = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setEncoding(strCharset);
        out.setFormat(format);
        return out;
    }

    public static XMLOutputter buildCompactXMLOutputter(String strCharset) {
        XMLOutputter out = new XMLOutputter();
        Format format = Format.getCompactFormat();
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        format.setOmitDeclaration(true);
        format.setEncoding(strCharset);
        out.setFormat(format);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document build(File file) throws JDOMException, IOException {
        ThreadLocal<SAXBuilder> threadLocal = SAX_BUILDER;
        synchronized (threadLocal) {
            return SAX_BUILDER.get().build(file);
        }
    }

    public static Document build(String filename) throws JDOMException, IOException {
        return JDOMUtils.build(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document build(Reader xmlread) throws JDOMException, IOException {
        ThreadLocal<SAXBuilder> threadLocal = SAX_BUILDER;
        synchronized (threadLocal) {
            return SAX_BUILDER.get().build(xmlread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document build(InputStream xmlin) throws JDOMException, IOException {
        ThreadLocal<SAXBuilder> threadLocal = SAX_BUILDER;
        synchronized (threadLocal) {
            return SAX_BUILDER.get().build(xmlin);
        }
    }

    public static void output(Document doc, File file) throws IOException {
        try (TempFileOutputStream tos = new TempFileOutputStream(file);){
            JDOMUtils.output(doc, (OutputStream)tos);
        }
    }

    public static void output(Document doc, String filename) throws IOException {
        JDOMUtils.output(doc, new File(filename));
    }

    public static void output(Document doc, Writer xmlWriter) throws IOException {
        JDOMUtils.outputXML(JDOMUtils.buildCompactXMLOutputter(), doc, xmlWriter);
    }

    public static void output(Document doc, OutputStream outStream) throws IOException {
        JDOMUtils.outputXML(JDOMUtils.buildCompactXMLOutputter(), doc, outStream);
    }

    public static void outputXML(XMLOutputter op, Document doc, Writer xmlWriter) throws IOException {
        op.output(doc, xmlWriter);
    }

    public static void outputXML(XMLOutputter op, Document doc, OutputStream outStream) throws IOException {
        op.output(doc, outStream);
    }
}

