/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.DataSourceException;
import org.geotools.data.complex.feature.type.Types;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.data.wfs.internal.parsers.XmlFeatureParser;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.gml3.GML;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.xmlpull.v1.XmlPullParserException;

public class XmlComplexFeatureParser
extends XmlFeatureParser<FeatureType, Feature> {
    private final ComplexFeatureBuilder featureBuilder;
    private Map<String, Attribute> discoveredComplexAttributes = new HashMap<String, Attribute>();
    private Map<String, ArrayList<Attribute>> placeholderComplexAttributes = new HashMap<String, ArrayList<Attribute>>();
    private Filter filter;

    public XmlComplexFeatureParser(InputStream getFeatureResponseStream, FeatureType targetType, QName featureDescriptorName) throws IOException {
        super(getFeatureResponseStream, targetType, featureDescriptorName);
        this.featureBuilder = new ComplexFeatureBuilder(this.targetType);
    }

    public XmlComplexFeatureParser(InputStream getFeatureResponseStream, FeatureType targetType, QName featureDescriptorName, Filter filter) throws IOException {
        super(getFeatureResponseStream, targetType, featureDescriptorName);
        this.featureBuilder = new ComplexFeatureBuilder(this.targetType);
        this.filter = filter;
    }

    @Override
    public Feature parse() throws IOException {
        String fid;
        try {
            ReturnAttribute nextAttribute;
            fid = this.seekFeature();
            if (fid == null) {
                return null;
            }
            while ((nextAttribute = this.parseNextAttribute((ComplexType)this.targetType)) != null) {
                if (!Property.class.isAssignableFrom(nextAttribute.value.getClass())) {
                    this.featureBuilder.append(nextAttribute.name, (Property)new AttributeImpl(nextAttribute.value, (AttributeDescriptor)this.targetType.getDescriptor(nextAttribute.name), null));
                    continue;
                }
                this.featureBuilder.append(nextAttribute.name, (Property)nextAttribute.value);
            }
        }
        catch (XmlPullParserException e) {
            throw new DataSourceException((Throwable)e);
        }
        Feature feature = this.featureBuilder.buildFeature(fid);
        if (this.filter == null || this.filter.evaluate((Object)feature)) {
            return feature;
        }
        return null;
    }

    private void registerGmlTarget(String id, Attribute value) {
        this.discoveredComplexAttributes.put(id, value);
        if (this.placeholderComplexAttributes.containsKey(id)) {
            for (Attribute placeholderComplexAttribute : this.placeholderComplexAttributes.get(id)) {
                placeholderComplexAttribute.setValue(value.getValue());
            }
        }
    }

    private Attribute resolveHref(String href, AttributeType expectedType) {
        if (href.startsWith("#")) {
            String hrefId = href.substring(1);
            if (this.discoveredComplexAttributes.containsKey(hrefId)) {
                return this.discoveredComplexAttributes.get(hrefId);
            }
            AttributeImpl placeholderComplexAttribute = new AttributeImpl(Collections.emptyList(), expectedType, null);
            if (!this.placeholderComplexAttributes.containsKey(hrefId)) {
                this.placeholderComplexAttributes.put(hrefId, new ArrayList());
            }
            this.placeholderComplexAttributes.get(hrefId).add((Attribute)placeholderComplexAttribute);
            return placeholderComplexAttribute;
        }
        AttributeImpl placeholderComplexAttribute = new AttributeImpl(Collections.emptyList(), expectedType, null);
        return placeholderComplexAttribute;
    }

    static AttributeType getSimpleContentType(AttributeType type) {
        Class binding = type.getBinding();
        if (binding == Collection.class) {
            return XmlComplexFeatureParser.getSimpleContentType(type.getSuper());
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReturnAttribute parseNextAttribute(ComplexType complexType) throws XmlPullParserException, IOException {
        int tagType;
        while ((tagType = this.parser.next()) != 2 && tagType != 3 && tagType != 1) {
        }
        if (tagType == 2) {
            NameImpl currentTagName = new NameImpl(this.parser.getNamespace(), this.parser.getName());
            PropertyDescriptor descriptor = complexType.getDescriptor((Name)currentTagName);
            if (descriptor == null) throw new RuntimeException(String.format("WFS response structure unexpected. Could not find descriptor in type '%s' for '%s'.", complexType, currentTagName));
            PropertyType type = descriptor.getType();
            String id = this.parser.getAttributeValue(GML.id.getNamespaceURI(), GML.id.getLocalPart());
            String href = this.parser.getAttributeValue("http://www.w3.org/1999/xlink", "href");
            if (href != null) {
                Attribute hrefAttribute = this.resolveHref(href, (AttributeType)type);
                while (this.parser.next() != 3) {
                }
                return new ReturnAttribute(id, (Name)currentTagName, hrefAttribute);
            }
            if (type instanceof ComplexType) {
                ReturnAttribute innerAttribute;
                AttributeBuilder attributeBuilder = new AttributeBuilder((FeatureFactory)new LenientFeatureFactoryImpl());
                attributeBuilder.setType((AttributeType)type);
                if (type.getBinding() == Collection.class && Types.isSimpleContentType((PropertyType)type)) {
                    this.parser.next();
                    String value = this.parser.getText();
                    ArrayList<AttributeImpl> list = new ArrayList<AttributeImpl>();
                    if (value != null || descriptor.isNillable()) {
                        AttributeType simpleContentType = XmlComplexFeatureParser.getSimpleContentType((AttributeType)type);
                        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                        Object convertedValue = ff.literal((Object)value).evaluate((Object)value, simpleContentType.getBinding());
                        AttributeDescriptorImpl simpleContentDescriptor = new AttributeDescriptorImpl(simpleContentType, ComplexFeatureConstants.SIMPLE_CONTENT, 1, 1, true, null);
                        list.add(new AttributeImpl(convertedValue, (AttributeDescriptor)simpleContentDescriptor, null));
                    }
                    while (this.parser.next() != 3) {
                    }
                    return new ReturnAttribute(id, (Name)currentTagName, list);
                }
                while ((innerAttribute = this.parseNextAttribute((ComplexType)type)) != null) {
                    if (ComplexAttribute.class.isAssignableFrom(innerAttribute.value.getClass())) {
                        ArrayList<Property> properties = new ArrayList<Property>();
                        properties.add((Property)innerAttribute.value);
                        attributeBuilder.add(innerAttribute.id, properties, innerAttribute.name);
                        continue;
                    }
                    attributeBuilder.add(innerAttribute.id, this.getValue(innerAttribute), innerAttribute.name);
                }
                Attribute attribteValue = type instanceof FeatureType ? attributeBuilder.build(id) : attributeBuilder.build();
                if (id == null) return new ReturnAttribute(id, (Name)currentTagName, attribteValue);
                this.registerGmlTarget(id, attribteValue);
                return new ReturnAttribute(id, (Name)currentTagName, attribteValue);
            }
            if (!(type instanceof AttributeType) && !(type instanceof GeometryType)) return null;
            Object attributeValue = super.parseAttributeValue((AttributeDescriptor)descriptor);
            return new ReturnAttribute(id, (Name)currentTagName, attributeValue);
        }
        if (tagType != 1) return null;
        this.close();
        return null;
    }

    private Object getValue(ReturnAttribute innerAttribute) {
        if (innerAttribute.value instanceof AttributeImpl) {
            return ((AttributeImpl)innerAttribute.value).getValue();
        }
        return innerAttribute.value;
    }

    private class ReturnAttribute {
        public final String id;
        public final Name name;
        public final Object value;

        public ReturnAttribute(String id, Name name, Object value) {
            this.id = id;
            this.name = name;
            this.value = value;
        }
    }
}

