/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import net.opengis.wfs20.ListStoredQueriesResponseType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import net.opengis.wfs20.StoredQueryListItemType;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wfs.WFSContentState;
import org.geotools.data.wfs.WFSFeatureSource;
import org.geotools.data.wfs.WFSFeatureStore;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.WFSStoredQueryFeatureSource;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.DescribeFeatureTypeResponse;
import org.geotools.data.wfs.internal.DescribeStoredQueriesRequest;
import org.geotools.data.wfs.internal.DescribeStoredQueriesResponse;
import org.geotools.data.wfs.internal.ListStoredQueriesRequest;
import org.geotools.data.wfs.internal.ListStoredQueriesResponse;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.parsers.EmfAppSchemaParser;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;

public class WFSDataStore
extends ContentDataStore {
    public static final String STORED_QUERY_CONFIGURATION_HINT = "WFS_NG_STORED_QUERY_CONFIGURATION";
    private final WFSClient client;
    private final Map<Name, QName> names;
    private final Map<QName, FeatureType> remoteFeatureTypes;
    private final Map<String, StoredQueryDescriptionType> storedQueryDescriptionTypes;
    private ReadWriteLock storedQueryDescriptionTypesLock;
    private ListStoredQueriesResponseType remoteStoredQueries;
    protected Map<String, String> configuredStoredQueries = new ConcurrentHashMap<String, String>();

    public WFSDataStore(WFSClient client) {
        this.client = client;
        this.names = new ConcurrentHashMap<Name, QName>();
        this.remoteFeatureTypes = new ConcurrentHashMap<QName, FeatureType>();
        this.storedQueryDescriptionTypes = new ConcurrentHashMap<String, StoredQueryDescriptionType>();
        this.storedQueryDescriptionTypesLock = new ReentrantReadWriteLock();
        this.setFilterFactory(CommonFactoryFinder.getFilterFactory(null));
        this.setGeometryFactory(new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
        this.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        this.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
    }

    public WFSServiceInfo getInfo() {
        return this.client.getInfo();
    }

    protected WFSContentState createContentState(ContentEntry entry) {
        return new WFSContentState(entry);
    }

    protected List<Name> createTypeNames() throws IOException {
        String namespaceURI = this.getNamespaceURI();
        Set<QName> remoteTypeNames = this.client.getRemoteTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(remoteTypeNames.size());
        for (QName qName : remoteTypeNames) {
            String localTypeName = this.client.getConfig().localTypeName(qName);
            NameImpl typeName = new NameImpl(namespaceURI == null ? qName.getNamespaceURI() : namespaceURI, localTypeName);
            names.add((Name)typeName);
            this.names.put((Name)typeName, qName);
        }
        for (Map.Entry entry : this.configuredStoredQueries.entrySet()) {
            String name = (String)entry.getKey();
            String storedQueryId = (String)entry.getValue();
            NameImpl typeName = new NameImpl(namespaceURI, name);
            names.add((Name)typeName);
            this.names.put((Name)typeName, this.getStoredQueryReturnType(storedQueryId));
        }
        return names;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        Object source;
        if (!this.isStoredQuery(entry.getName())) {
            QName remoteTypeName = this.getRemoteTypeName(entry.getName());
            source = new WFSFeatureSource(entry, this.client);
            if (this.client.supportsTransaction(remoteTypeName)) {
                source = new WFSFeatureStore((WFSFeatureSource)((Object)source));
            }
        } else {
            String storedQueryId = this.configuredStoredQueries.get(entry.getName().getLocalPart());
            StoredQueryDescriptionType desc = this.getStoredQueryDescriptionType(storedQueryId);
            source = new WFSStoredQueryFeatureSource(entry, this.client, desc);
        }
        return source;
    }

    private boolean isStoredQuery(Name name) {
        return this.configuredStoredQueries.containsKey(name.getLocalPart());
    }

    public QName getRemoteTypeName(Name localTypeName) throws IOException {
        QName qName;
        if (this.names.isEmpty()) {
            this.createTypeNames();
        }
        if (null == (qName = this.names.get(localTypeName))) {
            throw new NoSuchElementException(localTypeName.toString());
        }
        return qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListStoredQueriesResponseType getStoredQueryListResponse() throws IOException {
        WFSDataStore wFSDataStore = this;
        synchronized (wFSDataStore) {
            if (this.remoteStoredQueries == null) {
                ListStoredQueriesRequest request = this.client.createListStoredQueriesRequest();
                ListStoredQueriesResponse response = this.client.issueRequest(request);
                this.remoteStoredQueries = response.getListStoredQueriesResponse();
            }
        }
        return this.remoteStoredQueries;
    }

    public boolean supportsStoredQueries() {
        return this.client.supportsStoredQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureType getRemoteFeatureType(QName remoteTypeName) throws IOException {
        FeatureType remoteFeatureType;
        String lockObj;
        String string = lockObj = remoteTypeName.toString().intern();
        synchronized (string) {
            remoteFeatureType = this.remoteFeatureTypes.get(remoteTypeName);
            if (remoteFeatureType == null) {
                DescribeFeatureTypeRequest request = this.client.createDescribeFeatureTypeRequest();
                request.setTypeName(remoteTypeName);
                DescribeFeatureTypeResponse response = this.client.issueRequest(request);
                remoteFeatureType = response.getFeatureType();
                this.remoteFeatureTypes.put(remoteTypeName, remoteFeatureType);
            }
        }
        return remoteFeatureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredQueryDescriptionType getStoredQueryDescriptionType(String storedQueryId) throws IOException {
        StoredQueryDescriptionType desc;
        block6: {
            this.storedQueryDescriptionTypesLock.readLock().lock();
            desc = this.storedQueryDescriptionTypes.get(storedQueryId);
            this.storedQueryDescriptionTypesLock.readLock().unlock();
            if (desc == null) {
                this.storedQueryDescriptionTypesLock.writeLock().lock();
                desc = this.storedQueryDescriptionTypes.get(storedQueryId);
                try {
                    URI id;
                    if (desc != null) break block6;
                    DescribeStoredQueriesRequest request = this.client.createDescribeStoredQueriesRequest();
                    try {
                        id = new URI(storedQueryId);
                    }
                    catch (URISyntaxException use) {
                        throw new IOException(use);
                    }
                    request.getStoredQueryIds().add(id);
                    DescribeStoredQueriesResponse response = this.client.issueRequest(request);
                    desc = response.getStoredQueryDescriptions().get(0);
                    this.storedQueryDescriptionTypes.put(storedQueryId, desc);
                }
                finally {
                    this.storedQueryDescriptionTypesLock.writeLock().unlock();
                }
            }
        }
        return desc;
    }

    public SimpleFeatureType getRemoteSimpleFeatureType(QName remoteTypeName) throws IOException {
        FeatureType remoteFeatureType = this.getRemoteFeatureType(remoteTypeName);
        SimpleFeatureType remoteSimpleFeatureType = EmfAppSchemaParser.toSimpleFeatureType(remoteFeatureType);
        return remoteSimpleFeatureType;
    }

    public WFSClient getWfsClient() {
        return this.client;
    }

    public Name addStoredQuery(String localName, String storedQueryId) throws IOException {
        NameImpl name = new NameImpl(this.namespaceURI, localName);
        try {
            this.configuredStoredQueries.put(localName, storedQueryId);
            this.removeEntry((Name)name);
            this.getStoredQuerySchema(storedQueryId);
            this.names.put((Name)name, this.getStoredQueryReturnType(storedQueryId));
            return name;
        }
        catch (IOException e) {
            this.configuredStoredQueries.remove(localName);
            throw e;
        }
    }

    public QName getStoredQueryReturnType(String storedQueryId) throws IOException {
        ListStoredQueriesResponseType list = this.getStoredQueryListResponse();
        for (StoredQueryListItemType query : list.getStoredQuery()) {
            if (!query.getId().equals(storedQueryId)) continue;
            return (QName)query.getReturnFeatureType().get(0);
        }
        throw new IOException("Unknown stored query " + storedQueryId);
    }

    public SimpleFeatureType getStoredQuerySchema(String storedQueryId) throws IOException {
        QName returnType = this.getStoredQueryReturnType(storedQueryId);
        return this.getRemoteSimpleFeatureType(returnType);
    }

    public Map<String, String> getConfiguredStoredQueries() {
        return this.configuredStoredQueries;
    }

    public void removeStoredQuery(String localName) {
        NameImpl name = new NameImpl(this.namespaceURI, localName);
        this.names.remove(name);
        this.configuredStoredQueries.remove(localName);
    }

    public URL getCapabilitiesURL() {
        return this.client.getCapabilitiesURL();
    }
}

