/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.util.logging.Logging;

@Deprecated
public class MultithreadedHttpClient
implements HTTPClient {
    private static final Logger LOGGER = Logging.getLogger(MultithreadedHttpClient.class);
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HttpClient client;
    private String user;
    private String password;
    private boolean tryGzip;

    public MultithreadedHttpClient(WFSConfig config) {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setSoTimeout(config.getTimeoutMillis());
        params.setConnectionTimeout(config.getTimeoutMillis());
        params.setMaxTotalConnections(config.getMaxConnectionPoolSize());
        params.setDefaultMaxConnectionsPerHost(config.getMaxConnectionPoolSize());
        this.connectionManager.setParams(params);
        this.client = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.applySystemProxySettings();
    }

    private void applySystemProxySettings() {
        String proxyHost = System.getProperty("http.proxyHost");
        int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
        if (proxyHost != null) {
            LOGGER.fine("Found 'http.proxyHost' Java System property. Using it as proxy server. Port: " + proxyPort);
            HostConfiguration hostConfig = this.client.getHostConfiguration();
            hostConfig.setProxy(proxyHost, proxyPort);
        }
        String proxyUser = System.getProperty("http.proxyUser");
        String proxyPassword = System.getProperty("http.proxyPassword");
        if (proxyUser != null) {
            if (proxyPassword == null || proxyPassword.length() == 0) {
                LOGGER.warning("System property http.proxyUser provided but http.proxyPassword not provided or empty. Proxy auth credentials will be passed as is anyway.");
            } else {
                LOGGER.fine("System property http.proxyUser and http.proxyPassword found, setting proxy auth credentials");
            }
            HttpState state = this.client.getState();
            if (state == null) {
                state = new HttpState();
                this.client.setState(state);
            }
            AuthScope authscope = AuthScope.ANY;
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            state.setProxyCredentials(authscope, (Credentials)credentials);
        }
    }

    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        PostMethod postMethod = new PostMethod(url.toExternalForm());
        postMethod.setDoAuthentication(this.user != null && this.password != null);
        if (postContentType != null) {
            postMethod.setRequestHeader("Content-type", postContentType);
        }
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(postContent);
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        int responseCode = this.client.executeMethod((HttpMethod)postMethod);
        if (200 != responseCode) {
            postMethod.releaseConnection();
            throw new IOException("Server returned HTTP error code " + responseCode + " for URL " + url.toExternalForm());
        }
        return new HttpMethodResponse((HttpMethod)postMethod);
    }

    public HTTPResponse get(URL url) throws IOException {
        return this.get(url, null);
    }

    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        int responseCode;
        GetMethod getMethod = new GetMethod(url.toExternalForm());
        getMethod.setDoAuthentication(this.user != null && this.password != null);
        if (headers != null) {
            for (Map.Entry<String, String> headerNameValue : headers.entrySet()) {
                getMethod.setRequestHeader(headerNameValue.getKey(), headerNameValue.getValue());
            }
        }
        if (200 != (responseCode = this.client.executeMethod((HttpMethod)getMethod))) {
            getMethod.releaseConnection();
            throw new IOException("Server returned HTTP error code " + responseCode + " for URL " + url.toExternalForm());
        }
        return new HttpMethodResponse((HttpMethod)getMethod);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.resetCredentials();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.resetCredentials();
    }

    private void resetCredentials() {
        this.client.getState().clearCredentials();
        if (this.user != null && this.password != null) {
            AuthScope authscope = AuthScope.ANY;
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
            this.client.getParams().setAuthenticationPreemptive(true);
            this.client.getState().setCredentials(authscope, (Credentials)credentials);
        } else {
            this.client.getParams().setAuthenticationPreemptive(false);
        }
    }

    public int getConnectTimeout() {
        return this.connectionManager.getParams().getConnectionTimeout() / 1000;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectionManager.getParams().setConnectionTimeout(connectTimeout * 1000);
    }

    public int getReadTimeout() {
        return this.connectionManager.getParams().getSoTimeout() / 1000;
    }

    public void setReadTimeout(int readTimeout) {
        this.connectionManager.getParams().setSoTimeout(readTimeout * 1000);
    }

    public int getMaxConnections() {
        return this.connectionManager.getParams().getDefaultMaxConnectionsPerHost();
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionManager.getParams().setMaxTotalConnections(maxConnections);
        this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxConnections);
    }

    public void setTryGzip(boolean tryGZIP) {
        this.tryGzip = tryGZIP;
    }

    public boolean isTryGzip() {
        return this.tryGzip;
    }

    private static class HttpMethodResponse
    implements HTTPResponse {
        private HttpMethod methodResponse;
        private InputStream responseBodyAsStream;

        public HttpMethodResponse(HttpMethod methodResponse) {
            this.methodResponse = methodResponse;
        }

        public void dispose() {
            if (this.responseBodyAsStream != null) {
                try {
                    this.responseBodyAsStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.methodResponse != null) {
                this.methodResponse.releaseConnection();
                this.methodResponse = null;
            }
        }

        public String getContentType() {
            return this.getResponseHeader("Content-Type");
        }

        public String getResponseHeader(String headerName) {
            Header responseHeader = this.methodResponse.getResponseHeader(headerName);
            return responseHeader == null ? null : responseHeader.getValue();
        }

        public InputStream getResponseStream() throws IOException {
            if (this.responseBodyAsStream == null) {
                this.responseBodyAsStream = this.methodResponse.getResponseBodyAsStream();
            }
            return this.responseBodyAsStream;
        }

        public String getResponseCharset() {
            String responseCharSet = null;
            if (this.methodResponse instanceof HttpMethodBase) {
                responseCharSet = ((HttpMethodBase)this.methodResponse).getResponseCharSet();
            }
            return responseCharSet;
        }
    }
}

