/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Properties joinConfig(Properties ... props) {
        Properties configAll = new Properties();
        for (Properties currProp : props) {
            configAll.putAll((Map<?, ?>)currProp);
        }
        return configAll;
    }

    public static Properties readConfig(File configFile) throws IOException {
        Properties props = new Properties();
        if (configFile.isFile()) {
            PropertyUtils.loadPropertiesFromFile(props, configFile);
        }
        return props;
    }

    public static void loadPropertiesFromFile(Properties properties, File propertyFile) throws IOException {
        try (FileInputStream propertiesReader = new FileInputStream(propertyFile);){
            properties.loadFromXML(propertiesReader);
        }
    }

    public static void writePropertiesToFile(Properties properties, File propertyFile) throws IOException {
        try (FileOutputStream propertiesWriter = new FileOutputStream(propertyFile);){
            properties.storeToXML(propertiesWriter, "");
        }
    }

    public static File readFileProperty(Properties props, String configKey) {
        String fileValue = props.getProperty(configKey, "");
        return StringUtils.isNotBlank((CharSequence)fileValue) ? new File(fileValue) : null;
    }

    public static Charset readCharsetProperty(Properties props, String configKey, Charset defaultCharset) {
        String configValue;
        if (props.containsKey(configKey) && StringUtils.isNotBlank((CharSequence)(configValue = props.getProperty(configKey, "")))) {
            return Charset.forName(configValue);
        }
        return defaultCharset;
    }

    public static String readStringProperty(Properties props, String configKey, String defaultValue) {
        if (props.containsKey(configKey)) {
            String configValue = props.getProperty(configKey, "");
            return configValue;
        }
        return defaultValue;
    }

    public static Integer readIntegerProperty(Properties props, String configKey, Integer defaultValue) {
        if (props.containsKey(configKey)) {
            String configValue = props.getProperty(configKey, "");
            return Integer.parseInt(configValue);
        }
        return defaultValue;
    }
}

