/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryCodes {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryCodes.class);

    public static void writeBinaryMessage(OutputStream outStream, String message, Charset encoding, ByteOrder endianess) throws IOException {
        byte[] barr_msg = message.getBytes(encoding);
        BinaryCodes.writeBinaryMessage(outStream, barr_msg, endianess);
    }

    public static void writeBinaryMessage(OutputStream outStream, byte[] message, ByteOrder endianess) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(endianess);
        buf.putInt(message.length);
        outStream.write(buf.array());
        outStream.write(message);
    }

    public static byte[] createBinaryMessage(byte[] message, ByteOrder endianess) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            BinaryCodes.writeBinaryMessage(bos, message, endianess);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioex) {
                LOG.error(MessageFormat.format("Exception occured, but ByteOutputStream should NEVER throw IOException: {0}", ioex.getMessage()), (Throwable)ioex);
                return new byte[0];
            }
        }
        bos.close();
        return byArray;
    }
}

