/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.ui;

import de.riwagis.dms.DMSDocumentDesc;
import de.riwagis.dms.i18n.I18N;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSDocumentEditorDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(DMSDocumentEditorDialog.class);
    private int modalresult = -1;
    private JButton butCancelDMS;
    private JButton butSaveDMS;
    private JTextField edtDocumentName;
    private JLabel lblDMSID;
    private JLabel lblDocumentName;
    private JPanel pnlButtons;
    private JPanel pnlConfigServer1;
    private JTextField txtDMSID;

    public static DMSDocumentDesc inputDocumentDesc(Window parent) {
        return DMSDocumentEditorDialog.inputDocumentDesc(parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DMSDocumentDesc inputDocumentDesc(Window parent, DMSDocumentDesc prevDoc) {
        DMSDocumentEditorDialog editor = new DMSDocumentEditorDialog(parent);
        try {
            editor.setDocumentDesc(prevDoc);
            if (parent != null) {
                editor.setLocationRelativeTo(parent);
            }
            editor.setVisible(true);
            if (editor.getModalResult() == 0) {
                DMSDocumentDesc dMSDocumentDesc = editor.getDMSDocumentDesc();
                return dMSDocumentDesc;
            }
            DMSDocumentDesc dMSDocumentDesc = prevDoc;
            return dMSDocumentDesc;
        }
        finally {
            editor.dispose();
        }
    }

    public DMSDocumentEditorDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.i18n();
        this.setDocumentDesc(null);
        this.pack();
        SwingUtilities.getRootPane(this.butSaveDMS).setDefaultButton(this.butSaveDMS);
    }

    private void initComponents() {
        this.pnlConfigServer1 = new JPanel();
        this.lblDMSID = new JLabel();
        this.txtDMSID = new JTextField();
        this.lblDocumentName = new JLabel();
        this.edtDocumentName = new JTextField();
        this.pnlButtons = new JPanel();
        this.butCancelDMS = new JButton();
        this.butSaveDMS = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 120));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlConfigServer1.setMinimumSize(new Dimension(399, 54));
        this.pnlConfigServer1.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/dms/i18n/I18N");
        this.lblDMSID.setText(bundle.getString("de.riwagis.dms.ui.lbl_dmsid"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlConfigServer1.add((Component)this.lblDMSID, gridBagConstraints);
        this.txtDMSID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DMSDocumentEditorDialog.this.txtDMSIDFocusLost(evt);
            }
        });
        this.txtDMSID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DMSDocumentEditorDialog.this.txtDMSIDKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.pnlConfigServer1.add((Component)this.txtDMSID, gridBagConstraints);
        this.lblDocumentName.setText(bundle.getString("de.riwagis.dms.ui.lbl_documentname"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlConfigServer1.add((Component)this.lblDocumentName, gridBagConstraints);
        this.edtDocumentName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DMSDocumentEditorDialog.this.edtDocumentNameFocusLost(evt);
            }
        });
        this.edtDocumentName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DMSDocumentEditorDialog.this.edtDocumentNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.pnlConfigServer1.add((Component)this.edtDocumentName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlConfigServer1, gridBagConstraints);
        this.pnlButtons.setMinimumSize(new Dimension(215, 33));
        this.butCancelDMS.setText(bundle.getString("de.riwagis.dms.ui.btn_cancel"));
        this.butCancelDMS.setPreferredSize(new Dimension(100, 23));
        this.butCancelDMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMSDocumentEditorDialog.this.butCancelDMS_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancelDMS);
        this.butSaveDMS.setText(bundle.getString("de.riwagis.dms.ui.btn_save"));
        this.butSaveDMS.setPreferredSize(new Dimension(100, 23));
        this.butSaveDMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMSDocumentEditorDialog.this.butSaveDMS_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butSaveDMS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
    }

    private void butCancelDMS_onActionPerformed(ActionEvent evt) {
        this.modalresult = 2;
        this.setVisible(false);
    }

    private void butSaveDMS_onActionPerformed(ActionEvent evt) {
        this.modalresult = 0;
        this.setVisible(false);
    }

    private void txtDMSIDFocusLost(FocusEvent evt) {
        this.updateGUI();
    }

    private void edtDocumentNameFocusLost(FocusEvent evt) {
        this.updateGUI();
    }

    private void txtDMSIDKeyTyped(KeyEvent evt) {
        this.updateGUI();
    }

    private void edtDocumentNameKeyReleased(KeyEvent evt) {
        this.updateGUI();
    }

    private void setDocumentDesc(DMSDocumentDesc d) {
        if (d != null) {
            this.edtDocumentName.setText(d.getDocumentName());
            this.txtDMSID.setText(d.getId());
        } else {
            this.edtDocumentName.setText("");
            this.txtDMSID.setText("");
        }
        this.updateGUI();
    }

    private int getModalResult() {
        return this.modalresult;
    }

    private DMSDocumentDesc getDMSDocumentDesc() {
        return new DMSDocumentDesc(this.txtDMSID.getText(), this.edtDocumentName.getText());
    }

    private void updateGUI() {
        boolean isCommitable = StringUtils.isNotBlank((CharSequence)this.edtDocumentName.getText()) && StringUtils.isNotBlank((CharSequence)this.txtDMSID.getText());
        this.butSaveDMS.setEnabled(isCommitable);
    }

    private void i18n() {
        this.setTitle(I18N.getString("de.riwagis.dms.ui.dialogtitle"));
        this.lblDMSID.setText(I18N.getString("de.riwagis.dms.ui.lbl_dmsid"));
        this.lblDocumentName.setText(I18N.getString("de.riwagis.dms.ui.lbl_documentname"));
        this.butCancelDMS.setText(I18N.getString("de.riwagis.dms.ui.btn_cancel"));
        this.butSaveDMS.setText(I18N.getString("de.riwagis.dms.ui.btn_save"));
    }

    public static void main(String ... args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("MyTestApp");
                f.setSize(800, 600);
                f.setLocation(300, 200);
                f.setVisible(true);
                DMSDocumentDesc d = DMSDocumentEditorDialog.inputDocumentDesc(f);
                LOG.info(String.format("documentdesc: %s", d));
                f.dispose();
            }
        });
    }
}

