/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces.socket.message;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.interfaces.socket.DMSConnectorStatus;
import de.riwagis.dms.interfaces.socket.message.DMSConnectorAnswer;
import de.riwagis.dms.interfaces.socket.message.DMSConnectorCommand;
import de.riwagis.dms.interfaces.socket.message.MessageCoder;
import de.riwagis.dms.interfaces.socket.message.MessageEnvelope;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSONMessageCoder
implements MessageCoder {
    private static final Logger LOG = LoggerFactory.getLogger(GSONMessageCoder.class);
    private static final Gson GSON = new Gson();
    private final Charset encoding;
    private final MessageEnvelope messageEnvelope;

    public GSONMessageCoder(Charset encoding, MessageEnvelope messageEnvelope) {
        this.encoding = Objects.requireNonNull(encoding);
        this.messageEnvelope = messageEnvelope;
    }

    @Override
    public byte[] encode(DMSConnectorCommand command) throws IOException {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("command", command.getCommand());
        obj.put("payload", command.getPayload());
        String encodedString = String.format("%s", GSON.toJson(obj));
        return this.messageEnvelope.wrapMessage(encodedString, this.encoding);
    }

    @Override
    public DMSConnectorAnswer decode(byte[] message) throws IOException {
        String received = new String(message, this.encoding);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)received)) {
            DMSConnectorStatus tmpStatus = DMSConnectorStatus.UNKNOWN;
            String tmpErrortext = "";
            try {
                Map res = (Map)GSON.fromJson(received, Map.class);
                if (res == null) {
                    throw new IOException(I18N.format("de.riwagis.dms.ERROR_READ_GSON", received));
                }
                if (res.containsKey("status")) {
                    tmpStatus = DMSConnectorStatus.detect(ObjectUtils.toString(res.get("status")));
                } else {
                    tmpErrortext = I18N.getString("de.riwagis.dms.ERROR_SOCK_NOANSWER");
                }
                Object payloadObj = res.get("payload");
                if (payloadObj != null) {
                    if (payloadObj instanceof Map) {
                        Map payloadMap = (Map)payloadObj;
                        for (Map.Entry currEntry : payloadMap.entrySet()) {
                            if (currEntry.getKey() instanceof String) {
                                payload.put((String)currEntry.getKey(), currEntry.getValue());
                                continue;
                            }
                            tmpErrortext = I18N.format("de.riwagis.dms.ERROR_SOCK_ILLEGALPAYLOADENTRY", currEntry);
                        }
                    } else {
                        tmpErrortext = I18N.getString("de.riwagis.dms.ERROR_SOCK_ILLEGALPAYLOAD");
                    }
                }
                switch (tmpStatus) {
                    case UNKNOWN: {
                        break;
                    }
                    case WAIT: 
                    case OK: {
                        if (payloadObj == null) {
                            tmpErrortext = I18N.getString("de.riwagis.dms.ERROR_SOCK_NOPAYLOAD");
                        }
                        break;
                    }
                    default: {
                        tmpErrortext = ObjectUtils.toString(res.get("errortext"), (String)"unknown error");
                        break;
                    }
                }
            }
            catch (JsonSyntaxException ex) {
                tmpStatus = DMSConnectorStatus.FAIL;
                tmpErrortext = I18N.format("de.riwagis.dms.ERROR_SOCK_PARSEJSON", received, ex.getMessage());
            }
            if (StringUtils.isNotBlank((CharSequence)tmpErrortext)) {
                LOG.error(I18N.format("de.riwagis.dms.ERROR_SOCK_DECODE", tmpErrortext));
            }
            return new DMSConnectorAnswer(received, tmpStatus, payload, tmpErrortext);
        }
        return new DMSConnectorAnswer("", DMSConnectorStatus.FAIL, payload, I18N.getString("de.riwagis.dms.ERROR_SOCK_EMPTYMESSAGE"));
    }
}

