/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces.socket.message;

import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.interfaces.socket.message.DMSConnectorCommand;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultDMSConnectorCommand
implements DMSConnectorCommand {
    private final String command;
    private final Map<String, Object> payload = new LinkedHashMap<String, Object>();

    public DefaultDMSConnectorCommand(String command, Map<String, String> payload) {
        this.command = command;
        this.payload.putAll(payload);
    }

    public DefaultDMSConnectorCommand(String command) {
        this(command, Collections.emptyMap());
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public Map<String, Object> getPayload() {
        return Collections.unmodifiableMap(this.payload);
    }

    public void addPayload(String key, Object value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException(I18N.getString("de.riwagis.dms.ERROR_SOCK_EMPTYPAYLOAD"));
        }
        this.payload.put(key, value);
    }
}

