/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces.socket.message;

import de.riwagis.dms.interfaces.socket.DMSConnectorStatus;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DMSConnectorAnswer {
    private final String message;
    private final DMSConnectorStatus status;
    private final Map<String, Object> payload = new LinkedHashMap<String, Object>();
    private final String errorText;

    public DMSConnectorAnswer(String message, DMSConnectorStatus status, Map<String, Object> payload, String errorText) {
        this.message = Objects.requireNonNull(message);
        this.status = Objects.requireNonNull(status);
        this.payload.putAll(Objects.requireNonNull(payload));
        this.errorText = StringUtils.trimToEmpty((String)errorText);
    }

    public String getMessage() {
        return this.message;
    }

    public DMSConnectorStatus getStatus() {
        return this.status;
    }

    public Map<String, Object> getPayload() {
        return Collections.unmodifiableMap(this.payload);
    }

    public String toString() {
        return String.format("answer %s: %s", new Object[]{this.getStatus(), this.getMessage()});
    }

    public String getErrorText() {
        return this.errorText;
    }
}

