/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces.socket;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum DMSConnectorStatus {
    UNKNOWN(null),
    OK("(ok)"),
    FAIL("(fail)"),
    WAIT("(wait)"),
    CANCEL("(cancel)");

    private final Pattern statusTextPattern;

    private DMSConnectorStatus(String statusTextPattern) {
        this.statusTextPattern = StringUtils.isNotBlank((CharSequence)statusTextPattern) ? Pattern.compile(statusTextPattern, 2) : null;
    }

    public boolean isStatusTextPatternMatched(String statusText) {
        String statusTextTrimmed = StringUtils.trimToEmpty((String)statusText);
        return this.statusTextPattern != null ? this.statusTextPattern.matcher(statusTextTrimmed).matches() : false;
    }

    public static DMSConnectorStatus detect(String statusText) {
        if (StringUtils.isNotBlank((CharSequence)statusText)) {
            for (DMSConnectorStatus currStatus : DMSConnectorStatus.values()) {
                if (!currStatus.isStatusTextPatternMatched(statusText)) continue;
                return currStatus;
            }
        }
        return UNKNOWN;
    }
}

