/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces.socket;

import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.interfaces.socket.DMSConnectorStatus;
import de.riwagis.dms.interfaces.socket.DMSSocketConfig;
import de.riwagis.dms.interfaces.socket.message.DMSConnectorAnswer;
import de.riwagis.dms.interfaces.socket.message.DMSConnectorCommand;
import de.riwagis.dms.interfaces.socket.message.DefaultDMSConnectorCommand;
import de.riwagis.dms.interfaces.socket.message.MessageCoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSConnector
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DMSConnector.class);
    private final MessageCoder messageCoder;
    private final int socketTimeout;
    private final InetAddress remoteAddr;
    private final int remotePort;
    public static final String PAYLOADPARAM_SESSIONKEY = "session";

    public DMSConnector(DMSSocketConfig conf, MessageCoder messageCoder) {
        this.messageCoder = messageCoder;
        this.socketTimeout = conf.getSocketTimeout();
        this.remoteAddr = conf.getSocketAddress().getAddress();
        this.remotePort = conf.getSocketAddress().getPort();
    }

    public DMSConnectorAnswer issueSocketCommand(String command) throws IOException {
        DefaultDMSConnectorCommand message = new DefaultDMSConnectorCommand(command);
        return this.issueSocketCommand(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMSConnectorAnswer issueSocketCommand(DMSConnectorCommand message) throws IOException {
        DMSConnectorAnswer decodedMsg = this.issueCommand(message);
        if (decodedMsg.getStatus() == DMSConnectorStatus.WAIT) {
            String sessionKey = Objects.toString(decodedMsg.getPayload().get(PAYLOADPARAM_SESSIONKEY));
            if (StringUtils.isBlank((CharSequence)sessionKey)) {
                throw new IOException("wait status, but no session key retrieved.");
            }
            while (decodedMsg.getStatus() == DMSConnectorStatus.WAIT) {
                String string = sessionKey;
                synchronized (string) {
                    try {
                        sessionKey.wait(2000L);
                    }
                    catch (InterruptedException iex) {
                        LOG.debug("interruped wait: " + iex.getMessage(), (Throwable)iex);
                    }
                }
                DefaultDMSConnectorCommand waitCommand = new DefaultDMSConnectorCommand("read");
                waitCommand.addPayload(PAYLOADPARAM_SESSIONKEY, sessionKey);
                decodedMsg = this.issueCommand(waitCommand);
            }
        }
        return decodedMsg;
    }

    private DMSConnectorAnswer issueCommand(DMSConnectorCommand command) throws IOException {
        DMSConnectorAnswer decodedMsg;
        try (ByteArrayOutputStream receivedMessage = new ByteArrayOutputStream();){
            try (Socket s = new Socket();){
                s.setSoTimeout(this.socketTimeout);
                s.setKeepAlive(true);
                InetSocketAddress saddr = new InetSocketAddress(this.remoteAddr, this.remotePort);
                s.connect(saddr);
                if (!s.isConnected()) {
                    throw new IOException(I18N.format("de.riwagis.dms.socket.ERROR_NOT_CONNECTED", this.remoteAddr, this.remotePort));
                }
                try (InputStream is = s.getInputStream();
                     OutputStream os = s.getOutputStream();
                     BufferedOutputStream bos = new BufferedOutputStream(os);){
                    ((OutputStream)bos).write(this.messageCoder.encode(command));
                    ((OutputStream)bos).flush();
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)receivedMessage);
                    }
                    catch (SocketException sockex) {
                        LOG.debug(I18N.format("de.riwagis.dms.socket.error_copy", sockex.getMessage()), (Throwable)sockex);
                    }
                }
                catch (IOException ioex) {
                    throw new IOException(I18N.format("de.riwagis.dms.socket.error_connection", this.remoteAddr, this.remotePort, ioex.getMessage()), ioex);
                }
            }
            receivedMessage.flush();
            try {
                decodedMsg = this.messageCoder.decode(receivedMessage.toByteArray());
            }
            catch (IOException ioex) {
                throw new IOException(I18N.format("de.riwagis.dms.ERROR_MSG_DECODE", ioex.getMessage()), ioex);
            }
        }
        return decodedMsg;
    }

    @Override
    public void close() {
    }
}

