/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces.kic;

import de.riwagis.dms.DMSSupport;
import de.riwagis.dms.i18n.I18N;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiCLoginData {
    private static final Logger LOG = LoggerFactory.getLogger(KiCLoginData.class);
    private final String moduleKey;
    private final String dbLogin;
    private final String programLogin;
    private final String schemaname;

    private KiCLoginData(String moduleKey, String dbLogin, String programLogin, String schemaname) {
        this.moduleKey = StringUtils.trimToEmpty((String)moduleKey);
        this.dbLogin = dbLogin;
        this.programLogin = programLogin;
        this.schemaname = schemaname;
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public String getDbLogin() {
        return this.dbLogin;
    }

    public String getProgramLogin() {
        return this.programLogin;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public static KiCLoginData findLoginData(Map<String, KiCLoginData> loginDatas, String originKey) {
        List<String> currTest = DMSSupport.buildOriginKeyAlternatives(originKey);
        for (String currTest1 : currTest) {
            for (Map.Entry<String, KiCLoginData> currLoginDataKey : loginDatas.entrySet()) {
                if (!currLoginDataKey.getKey().equals(currTest1)) continue;
                return currLoginDataKey.getValue();
            }
        }
        return null;
    }

    public static final Map<String, KiCLoginData> parseLoginData(String logindatatxt) {
        Pattern p = Pattern.compile("\\s*(\\p{Graph}+)\\s*;\\s*(\\p{Graph}+)\\s*;\\s*(\\p{Graph}+)\\s*;\\s*(\\p{Graph}+)\\s*");
        LinkedHashMap<String, KiCLoginData> loginData2 = new LinkedHashMap<String, KiCLoginData>();
        for (String currLoginDataEntry : logindatatxt.split("\\|")) {
            Matcher currMatch = p.matcher(currLoginDataEntry);
            if (currMatch.matches()) {
                KiCLoginData d = new KiCLoginData(currMatch.group(1), currMatch.group(2), currMatch.group(3), currMatch.group(4));
                loginData2.put(d.getModuleKey(), d);
                continue;
            }
            LOG.warn(I18N.format("de.riwagis.dms.ERROR_LOGINDATA", currLoginDataEntry));
        }
        return loginData2;
    }
}

