/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DefaultDMSCapabilities;
import de.riwagis.dms.KnownDMSInterface;
import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.interfaces.socket.DMSConnector;
import de.riwagis.dms.interfaces.socket.DMSConnectorStatus;
import de.riwagis.dms.interfaces.socket.DMSSocketConfig;
import de.riwagis.dms.interfaces.socket.message.DMSConnectorAnswer;
import de.riwagis.dms.interfaces.socket.message.DefaultDMSConnectorCommand;
import de.riwagis.dms.interfaces.socket.message.GSONMessageCoder;
import de.riwagis.dms.interfaces.socket.message.MessageCoder;
import de.riwagis.dms.interfaces.socket.message.MessageEnvelope;
import de.riwagis.dms.interfaces.socket.message.NetStringEnvelope;
import de.riwagis.dms.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSInterfaceImplSocket
implements DMSInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DMSInterfaceImplSocket.class);
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private static final Integer DEFAULT_PORT = 26001;
    private static final Integer DEFAULT_SOCKET_TIMEOUT = 120000;
    private static final String DEFAULT_HOST = "localhost";
    private static final String CMD_READCAPABILITIES = "readcapabilities";
    private static final String CMD_DOCUMENT_INSERT = "insert";
    private static final String CMD_DOCUMENT_ATTACH = "attach";
    private static final String CMD_DOCUMENT_SHOW = "show";
    private static final MessageEnvelope DEFAULT_MESSAGEENVELOPE = NetStringEnvelope.ENVELOPE_LITTLE_ENDIAN;
    private static final DMSCapabilities FAIL_DMS_CAPABILITIES = new DefaultDMSCapabilities(false, false, false, false);
    public static final String CFG_DMS_SOCKET_HOST = "socket.host";
    public static final String CFG_DMS_SOCKET_PORT = "socket.port";
    public static final String CFG_DMS_ENCODING = "socket.charset";
    public static final String CFG_DMS_SOCKET_TIMEOUT = "socket.timeout";
    private static final String KEY_DMSID = "dmsid";
    private static final String KEY_FILEPATH = "filepath";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_ORIGINKEY = "originkey";
    private static final String KEY_DOCUMENTNAME = "documentname";
    private static final String KEY_ATTACHABLE = "attachable";
    private static final String KEY_INSERTABLE = "insertable";
    private final DMSSocketConfig socketConfig;
    private final MessageCoder messageCoder;
    private final DMSCapabilities capabilities;
    public static final DMSCreator DMSCREATOR = DMSInterfaceImplSocket::new;

    private DMSInterfaceImplSocket(Properties configuration) {
        this.socketConfig = DMSInterfaceImplSocket.readFromProperties(configuration);
        this.messageCoder = new GSONMessageCoder(this.socketConfig.getEncoding(), DEFAULT_MESSAGEENVELOPE);
        DMSCapabilities capabilities = FAIL_DMS_CAPABILITIES;
        try (DMSConnector conn = new DMSConnector(this.socketConfig, this.messageCoder);){
            DMSConnectorAnswer answer = conn.issueSocketCommand(CMD_READCAPABILITIES);
            if (answer.getStatus() == DMSConnectorStatus.OK) {
                Map<String, Object> payload = answer.getPayload();
                capabilities = new DefaultDMSCapabilities(true, BooleanUtils.toBooleanObject((String)ObjectUtils.toString((Object)payload.get(KEY_INSERTABLE))), BooleanUtils.toBooleanObject((String)ObjectUtils.toString((Object)payload.get(KEY_ATTACHABLE))), true);
            } else {
                LOG.error(String.format("error in connector to read capabilities: %s", new Object[]{answer.getStatus()}));
            }
        }
        catch (IOException ioex) {
            LOG.error(String.format("unable to read capabilities: %s", ioex.getMessage()), (Throwable)ioex);
        }
        this.capabilities = capabilities;
    }

    @Override
    public DMSDocument attachFromDMS(String originKey, Map<String, String> metadata) throws DMSException {
        try (DMSConnector conn = new DMSConnector(this.socketConfig, this.messageCoder);){
            DefaultDMSConnectorCommand command = new DefaultDMSConnectorCommand(CMD_DOCUMENT_ATTACH);
            command.addPayload(KEY_METADATA, metadata);
            command.addPayload(KEY_ORIGINKEY, originKey);
            DMSConnectorAnswer answer = conn.issueSocketCommand(command);
            if (null == answer.getStatus()) {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalstatus", new Object[]{answer.getStatus()}));
            }
            switch (answer.getStatus()) {
                case FAIL: {
                    throw new DMSException(I18N.format("de.riwagis.dms.socket.error-failure_attach", answer.getErrorText()));
                }
                case OK: {
                    String id = ObjectUtils.toString((Object)answer.getPayload().get(KEY_DMSID));
                    if (StringUtils.isBlank((CharSequence)id)) {
                        throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalid", id));
                    }
                    String documentName = ObjectUtils.toString((Object)answer.getPayload().get(KEY_DOCUMENTNAME), (String)String.format("Dokument %s", id));
                    DMSDocument dMSDocument = new DMSDocument(this.getDMSInterface(), id, documentName, originKey);
                    return dMSDocument;
                }
                case CANCEL: {
                    DMSDocument dMSDocument = null;
                    return dMSDocument;
                }
            }
            try {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalstatus", new Object[]{answer.getStatus()}));
            }
            catch (IOException ex) {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-attach", ex.getMessage()), ex);
            }
        }
    }

    @Override
    public DMSDocument insertToDMS(String originKey, File documentFile, Map<String, String> metadata, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        try (DMSConnector conn = new DMSConnector(this.socketConfig, this.messageCoder);){
            DefaultDMSConnectorCommand command = new DefaultDMSConnectorCommand(CMD_DOCUMENT_INSERT);
            command.addPayload(KEY_FILEPATH, documentFile.getAbsolutePath());
            command.addPayload(KEY_METADATA, metadata);
            command.addPayload(KEY_ORIGINKEY, originKey);
            DMSConnectorAnswer answer = conn.issueSocketCommand(command);
            if (null == answer.getStatus()) {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalstatus", new Object[]{answer.getStatus()}));
            }
            switch (answer.getStatus()) {
                case FAIL: {
                    throw new DMSException(I18N.format("de.riwagis.dms.socket.error-failure_insert", answer.getErrorText()));
                }
                case OK: {
                    String id = ObjectUtils.toString((Object)answer.getPayload().get(KEY_DMSID));
                    if (StringUtils.isBlank((CharSequence)id)) {
                        throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalid", id));
                    }
                    String documentName = ObjectUtils.toString((Object)answer.getPayload().get(KEY_DOCUMENTNAME), (String)String.format("Dokument %s", id));
                    DMSDocument dMSDocument = new DMSDocument(this.getDMSInterface(), id, documentName, originKey);
                    return dMSDocument;
                }
                case CANCEL: {
                    DMSDocument dMSDocument = null;
                    return dMSDocument;
                }
            }
            try {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalstatus", new Object[]{answer.getStatus()}));
            }
            catch (IOException ex) {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-insert", ex.getMessage()), ex);
            }
        }
    }

    @Override
    public KnownDMSInterface getDMSInterface() {
        return KnownDMSInterface.DMS_SOCKET;
    }

    @Override
    public String getName() {
        return KnownDMSInterface.DMS_SOCKET.getName();
    }

    @Override
    public void close() throws DMSException {
    }

    @Override
    public boolean showByID(DMSDocument document, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        try (DMSConnector conn = new DMSConnector(this.socketConfig, this.messageCoder);){
            DefaultDMSConnectorCommand command = new DefaultDMSConnectorCommand(CMD_DOCUMENT_SHOW);
            command.addPayload(KEY_DMSID, document.getId());
            command.addPayload(KEY_DOCUMENTNAME, document.getDocumentName());
            command.addPayload(KEY_ORIGINKEY, document.getOriginKey());
            DMSConnectorAnswer answer = conn.issueSocketCommand(command);
            if (null == answer.getStatus()) {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalstatus", new Object[]{answer.getStatus()}));
            }
            switch (answer.getStatus()) {
                case FAIL: {
                    throw new DMSException(I18N.format("de.riwagis.dms.socket.error-failure_show", answer.getErrorText()));
                }
                case OK: {
                    LOG.trace(String.format("document shown: %s", document));
                    boolean bl = true;
                    return bl;
                }
                case CANCEL: {
                    LOG.trace(String.format("document not shown: %s", document));
                    boolean bl = false;
                    return bl;
                }
            }
            try {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-illegalstatus", new Object[]{answer.getStatus()}));
            }
            catch (IOException ex) {
                throw new DMSException(I18N.format("de.riwagis.dms.socket.error-show", ex.getMessage()), ex);
            }
        }
    }

    @Override
    public DMSCapabilities getCapabilities() {
        return this.capabilities;
    }

    public static DMSSocketConfig readFromProperties(Properties configuration) {
        return new DMSSocketConfig(new InetSocketAddress(PropertyUtils.readStringProperty(configuration, CFG_DMS_SOCKET_HOST, DEFAULT_HOST), (int)PropertyUtils.readIntegerProperty(configuration, CFG_DMS_SOCKET_PORT, DEFAULT_PORT)), PropertyUtils.readCharsetProperty(configuration, CFG_DMS_ENCODING, DEFAULT_CHARSET), PropertyUtils.readIntegerProperty(configuration, CFG_DMS_SOCKET_TIMEOUT, DEFAULT_SOCKET_TIMEOUT));
    }
}

