/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DefaultDMSCapabilities;
import de.riwagis.dms.KnownDMSInterface;
import de.riwagis.dms.i18n.I18N;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSInterfaceImplMsgBox
implements DMSInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DMSInterfaceImplMsgBox.class);
    private static final String DMSINTERFACENAME = "MsgBox-DMS";
    private static final String DIALOG_TITLE = I18N.getString("de.riwagis.dms.msgbox.dialogtitle");
    public static final DMSCreator DMSCREATOR_MSGBOX = DMSInterfaceImplMsgBox::new;

    private DMSInterfaceImplMsgBox(Properties configuration) {
        LOG.trace(String.format("config: [%s]", StringUtils.join(configuration.entrySet(), (String)", ")));
    }

    @Override
    public String getName() {
        return this.getDMSInterface().getName();
    }

    @Override
    public KnownDMSInterface getDMSInterface() {
        return KnownDMSInterface.DMS_MSGBOX;
    }

    @Override
    public boolean showByID(DMSDocument document, Map<String, ?> uploadInfo, int moduleKey) {
        JOptionPane.showMessageDialog(null, I18N.format("de.riwagis.dms.msgbox.msg_show", DMSINTERFACENAME, document.getId(), document.getDocumentName(), document.getOriginKey()), DIALOG_TITLE, 2);
        return true;
    }

    @Override
    public DMSDocument insertToDMS(String originKey, File documentFile, Map<String, String> metadata, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        DMSDocument dd = new DMSDocument(KnownDMSInterface.DMS_MSGBOX, RandomStringUtils.randomNumeric((int)8), documentFile.getName(), originKey);
        JOptionPane.showMessageDialog(null, I18N.format("de.riwagis.dms.msgbox.msg_insertattach", DMSINTERFACENAME, dd.getId(), dd.getDocumentName(), originKey, StringUtils.join(metadata.entrySet(), (String)";")), DIALOG_TITLE, 2);
        return dd;
    }

    @Override
    public DMSDocument attachFromDMS(String originKey, Map<String, String> metadata) throws DMSException {
        DMSDocument dd = new DMSDocument(KnownDMSInterface.DMS_MSGBOX, RandomStringUtils.randomNumeric((int)8), String.format("%s.pdf", RandomStringUtils.randomAlphabetic((int)8)), originKey);
        JOptionPane.showMessageDialog(null, I18N.format("de.riwagis.dms.msgbox.msg_insertattach", DMSINTERFACENAME, dd.getId(), dd.getDocumentName(), originKey, StringUtils.join(metadata.entrySet(), (String)";")), DIALOG_TITLE, 2);
        return dd;
    }

    @Override
    public DMSCapabilities getCapabilities() {
        return DefaultDMSCapabilities.ALL;
    }

    @Override
    public void close() throws DMSException {
        LOG.debug("closing dms interface");
    }
}

