/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DefaultDMSCapabilities;
import de.riwagis.dms.KnownDMSInterface;
import de.riwagis.dms.common.ExecutorResult;
import de.riwagis.dms.common.ExecutorUtils;
import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.interfaces.kic.KiCLoginData;
import de.riwagis.dms.util.JDOMUtils;
import de.riwagis.dms.util.PropertyUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Parent;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSInterfaceImplKiC
implements DMSInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DMSInterfaceImplKiC.class);
    public static final String CFG_DMS_KIC_ARCHIVESEARCH = "kic.archivesearch_exe";
    public static final String CFG_DMS_KIC_ARCHIVEIMPORTFILE = "kic.archiveimportfile_exe";
    public static final String CFG_DMS_KIC_ARCHIVECONVERTTOPDFA = "kic.archiveConvertToPDFAExe_exe";
    public static final String CFG_DMS_KIC_LOGINDATA = "kic.logindata";
    public static final DMSCreator DMSCREATOR_KIC = DMSInterfaceImplKiC::new;
    private final File archiveImportFileExe;
    private final File archiveSearchExe;
    private final File archiveConvertToPDFAExe;
    private final Map<String, KiCLoginData> loginData = new LinkedHashMap<String, KiCLoginData>();
    private static final XMLOutputter xOut = new XMLOutputter(Format.getPrettyFormat());
    private static final Map<Integer, String> EXITCODES = DMSInterfaceImplKiC.buildExitCodes();

    private DMSInterfaceImplKiC(Properties configuration) {
        this.archiveImportFileExe = PropertyUtils.readFileProperty(configuration, CFG_DMS_KIC_ARCHIVEIMPORTFILE);
        this.archiveSearchExe = PropertyUtils.readFileProperty(configuration, CFG_DMS_KIC_ARCHIVESEARCH);
        this.archiveConvertToPDFAExe = PropertyUtils.readFileProperty(configuration, CFG_DMS_KIC_ARCHIVECONVERTTOPDFA);
        this.loginData.putAll(KiCLoginData.parseLoginData(configuration.getProperty(CFG_DMS_KIC_LOGINDATA, "")));
    }

    @Override
    public String getName() {
        return this.getDMSInterface().getName();
    }

    @Override
    public KnownDMSInterface getDMSInterface() {
        return KnownDMSInterface.DMS_KIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean showByID(DMSDocument document, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        if (this.archiveSearchExe.isFile()) {
            boolean bl;
            KiCLoginData dmsLogin = KiCLoginData.findLoginData(this.loginData, document.getOriginKey());
            Document d = new Document();
            Element elemRoot = JDOMUtils.addElement((Parent)d, "root");
            DMSInterfaceImplKiC.addDMSLogin(elemRoot, dmsLogin);
            JDOMUtils.addElement((Parent)elemRoot, "SearchTags", "___DOC_ID_TAG___");
            JDOMUtils.addElement((Parent)elemRoot, "SearchCaptions", "\"ID\"");
            JDOMUtils.addElement((Parent)elemRoot, "SearchDefaults", String.format("\"%s\"", document.getId()));
            JDOMUtils.addElement((Parent)elemRoot, "ListTags", "___DOC_ID_TAG___;___DOC_NAME_TAG___");
            JDOMUtils.addElement((Parent)elemRoot, "ListCaptions", "\"Dokument-ID\";\"Dokument-Name\"");
            JDOMUtils.addElement((Parent)elemRoot, "SearchButtonsVisible", "false");
            File tempFile = File.createTempFile("dmssearch.kic.", ".xml");
            LOG.info(I18N.format("de.riwagis.dms.kic.searchfile", document, tempFile));
            try {
                DMSInterfaceImplKiC.saveXML(d, tempFile);
                ExecutorResult runExecutable = ExecutorUtils.runExecutable(this.archiveSearchExe, tempFile.getAbsolutePath());
                int exitCode = runExecutable.getExitCode();
                if (exitCode < 0) {
                    String errText = (String)StringUtils.defaultIfBlank((CharSequence)EXITCODES.get(exitCode), (CharSequence)I18N.getString("de.riwagis.dms.kic.error_startkic_unknown"));
                    throw new DMSException(I18N.format("de.riwagis.dms.kic.error_startkic_returnvalue", this.archiveConvertToPDFAExe, document.getDocumentName(), errText, exitCode));
                }
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.deleteQuietly((File)tempFile);
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new DMSException(I18N.format("de.riwagis.dms.kic.error_startkic", this.archiveSearchExe, ex.getMessage(), "show"), ex);
                }
            }
            FileUtils.deleteQuietly((File)tempFile);
            return bl;
        }
        throw new DMSException(I18N.format("de.riwagis.dms.kic.error_startkic_notfound", this.archiveSearchExe));
    }

    public static void addDMSLogin(Element elemRoot, KiCLoginData dmsLogin) {
        JDOMUtils.addElement((Parent)elemRoot, "dblogin", dmsLogin.getDbLogin());
        JDOMUtils.addElement((Parent)elemRoot, "programlogin", dmsLogin.getProgramLogin());
        JDOMUtils.addElement((Parent)elemRoot, "schemaname", dmsLogin.getSchemaname());
    }

    @Override
    public DMSDocument insertToDMS(String originKey, File documentFile, Map<String, String> metadata, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        ExecutorResult runExecutable;
        File convertedDocFile;
        String documentExtension = FilenameUtils.getExtension((String)documentFile.getName());
        if (!StringUtils.equalsIgnoreCase((CharSequence)documentExtension, (CharSequence)"pdf") || StringUtils.equalsIgnoreCase((CharSequence)documentExtension, (CharSequence)"tif")) {
            try {
                convertedDocFile = DMSInterfaceImplKiC.convertDocumentKiC(this.archiveConvertToPDFAExe, documentFile);
            }
            catch (IOException ex) {
                throw new DMSException(I18N.format("de.riwagis.dms.kic.error_startkic", this.archiveConvertToPDFAExe, ex.getMessage(), "convert"), ex);
            }
        } else {
            convertedDocFile = documentFile;
        }
        KiCLoginData dmsLogin = KiCLoginData.findLoginData(this.loginData, originKey);
        File metadataFile = new File(convertedDocFile.getParentFile(), FilenameUtils.removeExtension((String)convertedDocFile.getName()).concat(".txt"));
        DMSInterfaceImplKiC.writeKiCMetadataFile(metadata, metadataFile, dmsLogin);
        try {
            LOG.info(I18N.format("de.riwagis.dms.kic.insertfile", convertedDocFile, metadataFile));
            runExecutable = ExecutorUtils.runExecutable(this.archiveImportFileExe, convertedDocFile.getAbsolutePath(), "HideDialog=1");
        }
        catch (IOException ex) {
            throw new DMSException(I18N.format("de.riwagis.dms.kic.error_startkic", this.archiveImportFileExe, ex.getMessage(), "insert"), ex);
        }
        int exitCode = runExecutable.getExitCode();
        if (exitCode < 0) {
            String errText = (String)StringUtils.defaultIfBlank((CharSequence)EXITCODES.get(exitCode), (CharSequence)I18N.getString("de.riwagis.dms.kic.error_startkic_unknown"));
            throw new DMSException(I18N.format("de.riwagis.dms.kic.error_startkic_returnvalue", this.archiveConvertToPDFAExe, convertedDocFile, errText, exitCode));
        }
        return new DMSDocument(KnownDMSInterface.DMS_KIC, Integer.toString(exitCode), documentFile.getName(), originKey);
    }

    @Override
    public DMSDocument attachFromDMS(String originKey, Map<String, String> metadata) throws DMSException {
        throw new DMSException("Not supported yet.");
    }

    public static void writeKiCMetadataFile(Map<String, String> metadata, File metadataFile, KiCLoginData loginInfo) throws DMSException {
        Document d = new Document();
        Element elemKicarchive = JDOMUtils.addElement((Parent)d, "kicarchive");
        DMSInterfaceImplKiC.addDMSLogin(elemKicarchive, loginInfo);
        Element elemDocument = JDOMUtils.addElement((Parent)elemKicarchive, "document");
        JDOMUtils.addElement((Parent)elemDocument, "name");
        Element elemXmldata = JDOMUtils.addElement((Parent)elemDocument, "xmldata");
        Element elemRoot = JDOMUtils.addElement((Parent)elemXmldata, "root");
        for (Map.Entry<String, String> currEntry : metadata.entrySet()) {
            JDOMUtils.addElement((Parent)elemRoot, currEntry.getKey(), currEntry.getValue());
        }
        try {
            DMSInterfaceImplKiC.saveXML(d, metadataFile);
        }
        catch (IOException ex) {
            throw new DMSException(I18N.format("de.riwagis.dms.kic.error_save_metadata", metadataFile, ex.getMessage()), ex);
        }
    }

    public static void saveXML(Document document, File xmlFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(xmlFile);){
            xOut.output(document, (OutputStream)out);
        }
    }

    @Override
    public void close() throws DMSException {
        LOG.trace("close called");
    }

    private static File convertDocumentKiC(File archiveConvertToPDFAExe, File documentFile) throws IOException {
        if (documentFile == null || !documentFile.isFile()) {
            throw new IOException(I18N.format("de.riwagis.dms.kic.error_illegaldocument", documentFile));
        }
        if (archiveConvertToPDFAExe != null && archiveConvertToPDFAExe.isFile()) {
            File f = File.createTempFile("kicdms.", ".pdf", documentFile.getParentFile());
            ExecutorUtils.runExecutable(archiveConvertToPDFAExe, documentFile.getAbsolutePath(), f.getAbsolutePath());
            return f;
        }
        throw new IOException(I18N.format("de.riwagis.dms.kic.error_noconverter", documentFile, archiveConvertToPDFAExe));
    }

    private static Map<Integer, String> buildExitCodes() {
        LinkedHashMap<Integer, String> res = new LinkedHashMap<Integer, String>();
        res.put(-1, "ErrorNoFileToImport");
        res.put(-2, "ErrorFileNotFound");
        res.put(-11, "ArchiveComServerNotFound");
        res.put(-12, "ErrorArchiveLogin");
        res.put(-13, "ErrorArchiveStoreDoc");
        res.put(-100, "FatalError");
        return res;
    }

    @Override
    public DMSCapabilities getCapabilities() {
        return new DefaultDMSCapabilities(true, true, false, true);
    }
}

