/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DefaultDMSCapabilities;
import de.riwagis.dms.KnownDMSInterface;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSInterfaceImplGenericInterface
implements DMSInterface {
    private static final Logger log = LoggerFactory.getLogger(DMSInterfaceImplGenericInterface.class);
    public static DmsServiceAdapter dmsServiceAdapter;
    public static final DMSCreator DMSCREATOR_GENERICINTERFACE;

    @Override
    public String getName() {
        return KnownDMSInterface.DMS_GENERICINTERFACE.getName();
    }

    @Override
    public KnownDMSInterface getDMSInterface() {
        return KnownDMSInterface.DMS_GENERICINTERFACE;
    }

    @Override
    public boolean showByID(DMSDocument document, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        UUID documentUUID = UUID.fromString(document.getId());
        Integer dmsServiceId = (Integer)uploadInfo.get("dmsServiceId");
        Integer dmsServiceIdOfProcess = (Integer)uploadInfo.get("dmsServiceIdOfProcess");
        Integer fileUploadId = (Integer)uploadInfo.get("fileUploadId");
        Object pkValueOfProcess = uploadInfo.get("pkValueOfProcess");
        Object pkValueOfDocument = uploadInfo.get("filter_id");
        dmsServiceAdapter.showDocument(documentUUID, moduleKey, fileUploadId, dmsServiceId, dmsServiceIdOfProcess, pkValueOfProcess, pkValueOfDocument).join();
        return true;
    }

    @Override
    public DMSDocument insertToDMS(String originKey, File documentFile, Map<String, String> metadata, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        Object pkValueOfDocument;
        if (moduleKey <= 0 || uploadInfo == null) {
            throw new UnsupportedOperationException("This operation is not supported yet.");
        }
        Integer fileUploadId = (Integer)uploadInfo.get("fileUploadId");
        Integer dmsServiceIdOfProcess = (Integer)uploadInfo.get("dmsServiceIdOfProcess");
        Object pkValueOfProcess = uploadInfo.get("pkValueOfProcess");
        String documentUUID = dmsServiceAdapter.uploadDocument(moduleKey, fileUploadId, pkValueOfProcess, pkValueOfDocument = uploadInfo.get("filter_id"), dmsServiceIdOfProcess, documentFile).join().toString();
        if (StringUtils.isBlank((CharSequence)documentUUID)) {
            throw new DMSException("Generic interface did not return a document UUID.");
        }
        return new DMSDocument(KnownDMSInterface.DMS_GENERICINTERFACE, documentUUID, documentFile.getName(), originKey);
    }

    @Override
    public DMSDocument attachFromDMS(String originKey, Map<String, String> metadata) throws DMSException {
        throw new UnsupportedOperationException("Attaching existing files from DMS is not supported.");
    }

    @Override
    public DMSCapabilities getCapabilities() {
        return new DefaultDMSCapabilities(true, true, false, false);
    }

    @Override
    public String computeOriginKey(int moduleKey, int dialogKey, Integer fieldKey) {
        return null;
    }

    @Override
    public void close() throws DMSException {
        log.debug("Shutting down DMS integration.");
    }

    static {
        DMSCREATOR_GENERICINTERFACE = configuration -> new DMSInterfaceImplGenericInterface();
    }

    public static interface DmsServiceAdapter {
        public CompletableFuture<UUID> uploadDocument(int var1, Integer var2, Object var3, Object var4, Integer var5, File var6);

        public CompletableFuture<Void> showDocument(UUID var1, int var2, int var3, int var4, int var5, Object var6, Object var7);
    }
}

