/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.interfaces;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSCreator;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSException;
import de.riwagis.dms.DMSInterface;
import de.riwagis.dms.DefaultDMSCapabilities;
import de.riwagis.dms.KnownDMSInterface;
import de.riwagis.dms.i18n.I18N;
import de.riwagis.dms.util.PropertyUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSInterfaceImplFilesystem
implements DMSInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DMSInterfaceImplFilesystem.class);
    public static final String CFG_DMS_FS_BASEDIR = "riwadmsfs.basedir";
    private final File basedir;
    private final Properties hashIndex = new Properties();
    private final File indexfile;
    private final DMSCapabilities capabilities;
    public static final DMSCreator DMSCREATOR_FILESYSTEM = DMSInterfaceImplFilesystem::new;

    private DMSInterfaceImplFilesystem(Properties configuration) throws DMSException {
        this.basedir = PropertyUtils.readFileProperty(configuration, CFG_DMS_FS_BASEDIR);
        this.indexfile = new File(this.basedir, "_dmsindex.csv");
        if (!this.basedir.exists() && !this.basedir.mkdirs()) {
            LOG.error(I18N.format("de.riwagis.dms.ERROR_CREATEDIR", this.basedir.getAbsoluteFile()));
        }
        if (!this.indexfile.exists()) {
            try {
                PropertyUtils.writePropertiesToFile(new Properties(), this.indexfile);
            }
            catch (IOException ex) {
                LOG.error(I18N.format("de.riwagis.dms.ERROR_WRITEFILE", this.indexfile, ex.getMessage()), (Throwable)ex);
            }
        }
        if (this.basedir.isDirectory() && this.indexfile.isFile()) {
            this.capabilities = new DefaultDMSCapabilities(true, true, true, true);
        } else {
            LOG.error(I18N.format("de.riwagis.dms.ERROR_MISSING_FILES", this.basedir.getAbsoluteFile(), this.indexfile.getAbsoluteFile()));
            this.capabilities = DefaultDMSCapabilities.NONE;
        }
    }

    @Override
    public String getName() {
        return KnownDMSInterface.DMS_FILESYSTEM.getName();
    }

    @Override
    public KnownDMSInterface getDMSInterface() {
        return KnownDMSInterface.DMS_FILESYSTEM;
    }

    @Override
    public boolean showByID(DMSDocument document, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        File documentFile;
        this.reloadIndex();
        if (this.hashIndex.containsKey(document.getId()) && (documentFile = new File(this.basedir, this.hashIndex.getProperty(document.getId()))).isFile()) {
            try {
                Desktop.getDesktop().open(documentFile);
                return true;
            }
            catch (IOException ex) {
                throw new DMSException(I18N.format("de.riwagis.dms.ERROR_OPEN_FILE", documentFile, ex.getMessage()), ex);
            }
        }
        return false;
    }

    @Override
    public DMSDocument insertToDMS(String originKey, File documentFile, Map<String, String> metadata, Map<String, ?> uploadInfo, int moduleKey) throws DMSException {
        this.reloadIndex();
        try {
            String newKey;
            while (this.hashIndex.containsKey(newKey = RandomStringUtils.randomNumeric((int)12))) {
            }
            File dstFile = new File(this.basedir, String.format("%s_%s", newKey, documentFile.getName()));
            this.writeMetadataFile(dstFile, metadata);
            FileUtils.copyFile((File)documentFile, (File)dstFile);
            this.hashIndex.setProperty(newKey, dstFile.getName());
            this.rewriteIndex();
            return new DMSDocument(KnownDMSInterface.DMS_FILESYSTEM, newKey, dstFile.getName(), originKey);
        }
        catch (IOException ioex) {
            throw new DMSException(I18N.format("de.riwagis.dms.ERROR_READFILE", this.indexfile, ioex.getMessage()), ioex);
        }
    }

    public void writeMetadataFile(File dstFile, Map<String, String> metadata) throws IOException {
        File dstMeta = new File(this.basedir, String.format("%s.meta", FilenameUtils.removeExtension((String)dstFile.getName())));
        Properties p = new Properties();
        p.putAll(metadata);
        PropertyUtils.writePropertiesToFile(p, dstMeta);
    }

    public void rewriteIndex() throws DMSException {
        try {
            PropertyUtils.writePropertiesToFile(this.hashIndex, this.indexfile);
        }
        catch (IOException ioex) {
            throw new DMSException(I18N.format("de.riwagis.dms.ERROR_WRITEFILE", this.indexfile, ioex.getMessage()), ioex);
        }
    }

    public void reloadIndex() throws DMSException {
        try {
            if (this.indexfile.exists()) {
                PropertyUtils.loadPropertiesFromFile(this.hashIndex, this.indexfile);
            }
        }
        catch (IOException ioex) {
            throw new DMSException(I18N.format("de.riwagis.dms.ERROR_READFILE", this.indexfile, ioex.getMessage()), ioex);
        }
    }

    @Override
    public DMSDocument attachFromDMS(String originKey, Map<String, String> metadata) throws DMSException {
        this.reloadIndex();
        if (!this.hashIndex.isEmpty()) {
            ArrayList<Object> availableFiles = new ArrayList<Object>();
            availableFiles.addAll(this.hashIndex.values());
            Collections.sort(availableFiles, Collator.getInstance()::compare);
            Object res = JOptionPane.showInputDialog(null, I18N.getString("de.riwagis.dms.interface.dialogFileSelect.message"), I18N.getString("de.riwagis.dms.interface.dialogFileSelect.title"), 3, null, availableFiles.toArray(new String[availableFiles.size()]), "");
            if (res != null) {
                String key = StringUtils.substringBefore((String)((String)res), (String)"_");
                String docName = this.hashIndex.getProperty(key);
                return docName != null ? new DMSDocument(KnownDMSInterface.DMS_FILESYSTEM, key, docName, originKey) : null;
            }
            return null;
        }
        JOptionPane.showMessageDialog(null, I18N.format("de.riwagis.dms.interface.errorNoFiles", this.indexfile));
        return null;
    }

    @Override
    public DMSCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void close() throws DMSException {
        LOG.trace("close called");
    }
}

