/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.dms.common;

import de.riwagis.dms.common.ExecutorResult;
import de.riwagis.dms.i18n.I18N;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorUtils.class);

    private ExecutorUtils() {
    }

    public static ExecutorResult runExecutable(File executable, String ... arguments) throws IOException {
        if (executable != null && executable.isFile()) {
            try (ByteArrayOutputStream stdout = new ByteArrayOutputStream();){
                PumpStreamHandler psh = new PumpStreamHandler((OutputStream)stdout);
                DefaultExecutor executor = new DefaultExecutor();
                executor.setExitValues(null);
                executor.setStreamHandler((ExecuteStreamHandler)psh);
                CommandLine cl = new CommandLine(executable);
                for (String argument : arguments) {
                    cl.addArgument(argument);
                }
                LOG.info(I18N.format("de.riwagis.dms.executorutils.starting", cl));
                int exitCode = executor.execute(cl);
                String output = stdout.toString(Charset.defaultCharset().name());
                ExecutorResult executorResult = new ExecutorResult(output, exitCode);
                return executorResult;
            }
        }
        throw new IOException(I18N.format("de.riwagis.dms.executorutils.notfound", executable));
    }
}

